package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ListApplicationsResponse(
    applications: Option[
      Iterable[zio.aws.serverlessapplicationrepository.model.ApplicationSummary]
    ] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse = {
    import ListApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse
      .builder()
      .optionallyWith(
        applications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applications)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.ListApplicationsResponse.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.ListApplicationsResponse
      .wrap(buildAwsValue())
}
object ListApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.ListApplicationsResponse =
      zio.aws.serverlessapplicationrepository.model.ListApplicationsResponse(
        applications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def applications: Option[List[
      zio.aws.serverlessapplicationrepository.model.ApplicationSummary.ReadOnly
    ]]
    def nextToken: Option[__string]
    def getApplications: ZIO[Any, AwsError, List[
      zio.aws.serverlessapplicationrepository.model.ApplicationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("applications", applications)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse
  ) extends zio.aws.serverlessapplicationrepository.model.ListApplicationsResponse.ReadOnly {
    override val applications: Option[List[
      zio.aws.serverlessapplicationrepository.model.ApplicationSummary.ReadOnly
    ]] = scala
      .Option(impl.applications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.ApplicationSummary
            .wrap(item)
        }.toList
      )
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse
  ): zio.aws.serverlessapplicationrepository.model.ListApplicationsResponse.ReadOnly =
    new Wrapper(impl)
}
