package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.{
  __boolean,
  __string
}
import scala.jdk.CollectionConverters.*
final case class Version(
    applicationId: __string,
    creationTime: __string,
    parameterDefinitions: Iterable[
      zio.aws.serverlessapplicationrepository.model.ParameterDefinition
    ],
    requiredCapabilities: Iterable[
      zio.aws.serverlessapplicationrepository.model.Capability
    ],
    resourcesSupported: __boolean,
    semanticVersion: __string,
    sourceCodeArchiveUrl: Option[__string] = None,
    sourceCodeUrl: Option[__string] = None,
    templateUrl: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.Version = {
    import Version.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.Version
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .creationTime(__string.unwrap(creationTime): java.lang.String)
      .parameterDefinitions(parameterDefinitions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .requiredCapabilitiesWithStrings(requiredCapabilities.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .resourcesSupported(
        __boolean.unwrap(resourcesSupported): java.lang.Boolean
      )
      .semanticVersion(__string.unwrap(semanticVersion): java.lang.String)
      .optionallyWith(
        sourceCodeArchiveUrl.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.sourceCodeArchiveUrl)
      .optionallyWith(
        sourceCodeUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.sourceCodeUrl)
      .templateUrl(__string.unwrap(templateUrl): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.Version.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.Version.wrap(buildAwsValue())
}
object Version {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.Version
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.serverlessapplicationrepository.model.Version =
      zio.aws.serverlessapplicationrepository.model.Version(
        applicationId,
        creationTime,
        parameterDefinitions.map { item =>
          item.asEditable
        },
        requiredCapabilities,
        resourcesSupported,
        semanticVersion,
        sourceCodeArchiveUrl.map(value => value),
        sourceCodeUrl.map(value => value),
        templateUrl
      )
    def applicationId: __string
    def creationTime: __string
    def parameterDefinitions: List[
      zio.aws.serverlessapplicationrepository.model.ParameterDefinition.ReadOnly
    ]
    def requiredCapabilities
        : List[zio.aws.serverlessapplicationrepository.model.Capability]
    def resourcesSupported: __boolean
    def semanticVersion: __string
    def sourceCodeArchiveUrl: Option[__string]
    def sourceCodeUrl: Option[__string]
    def templateUrl: __string
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getCreationTime: ZIO[Any, Nothing, __string] = ZIO.succeed(creationTime)
    def getParameterDefinitions: ZIO[Any, Nothing, List[
      zio.aws.serverlessapplicationrepository.model.ParameterDefinition.ReadOnly
    ]] = ZIO.succeed(parameterDefinitions)
    def getRequiredCapabilities: ZIO[Any, Nothing, List[
      zio.aws.serverlessapplicationrepository.model.Capability
    ]] = ZIO.succeed(requiredCapabilities)
    def getResourcesSupported: ZIO[Any, Nothing, __boolean] =
      ZIO.succeed(resourcesSupported)
    def getSemanticVersion: ZIO[Any, Nothing, __string] =
      ZIO.succeed(semanticVersion)
    def getSourceCodeArchiveUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceCodeArchiveUrl", sourceCodeArchiveUrl)
    def getSourceCodeUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceCodeUrl", sourceCodeUrl)
    def getTemplateUrl: ZIO[Any, Nothing, __string] = ZIO.succeed(templateUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.Version
  ) extends zio.aws.serverlessapplicationrepository.model.Version.ReadOnly {
    override val applicationId: __string =
      zio.aws.serverlessapplicationrepository.model.primitives
        .__string(impl.applicationId())
    override val creationTime: __string =
      zio.aws.serverlessapplicationrepository.model.primitives
        .__string(impl.creationTime())
    override val parameterDefinitions: List[
      zio.aws.serverlessapplicationrepository.model.ParameterDefinition.ReadOnly
    ] = impl
      .parameterDefinitions()
      .asScala
      .map { item =>
        zio.aws.serverlessapplicationrepository.model.ParameterDefinition
          .wrap(item)
      }
      .toList
    override val requiredCapabilities
        : List[zio.aws.serverlessapplicationrepository.model.Capability] = impl
      .requiredCapabilities()
      .asScala
      .map { item =>
        zio.aws.serverlessapplicationrepository.model.Capability.wrap(item)
      }
      .toList
    override val resourcesSupported: __boolean =
      zio.aws.serverlessapplicationrepository.model.primitives
        .__boolean(impl.resourcesSupported())
    override val semanticVersion: __string =
      zio.aws.serverlessapplicationrepository.model.primitives
        .__string(impl.semanticVersion())
    override val sourceCodeArchiveUrl: Option[__string] = scala
      .Option(impl.sourceCodeArchiveUrl())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val sourceCodeUrl: Option[__string] = scala
      .Option(impl.sourceCodeUrl())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val templateUrl: __string =
      zio.aws.serverlessapplicationrepository.model.primitives
        .__string(impl.templateUrl())
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.Version
  ): zio.aws.serverlessapplicationrepository.model.Version.ReadOnly =
    new Wrapper(impl)
}
