package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UnshareApplicationRequest(
    applicationId: __string,
    organizationId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.UnshareApplicationRequest = {
    import UnshareApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.UnshareApplicationRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .organizationId(__string.unwrap(organizationId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.UnshareApplicationRequest.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.UnshareApplicationRequest
      .wrap(buildAwsValue())
}
object UnshareApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.UnshareApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.UnshareApplicationRequest =
      zio.aws.serverlessapplicationrepository.model
        .UnshareApplicationRequest(applicationId, organizationId)
    def applicationId: __string
    def organizationId: __string
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getOrganizationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(organizationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.UnshareApplicationRequest
  ) extends zio.aws.serverlessapplicationrepository.model.UnshareApplicationRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.serverlessapplicationrepository.model.primitives
        .__string(impl.applicationId())
    override val organizationId: __string =
      zio.aws.serverlessapplicationrepository.model.primitives
        .__string(impl.organizationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.UnshareApplicationRequest
  ): zio.aws.serverlessapplicationrepository.model.UnshareApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
