package zio.aws.serverlessapplicationrepository.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.{
  MaxItems,
  __string
}
import scala.jdk.CollectionConverters.*
final case class ListApplicationDependenciesRequest(
    applicationId: __string,
    maxItems: Option[MaxItems] = None,
    nextToken: Option[__string] = None,
    semanticVersion: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest = {
    import ListApplicationDependenciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .optionallyWith(maxItems.map(value => MaxItems.unwrap(value): Integer))(
        _.maxItems
      )
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        semanticVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.semanticVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesRequest.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesRequest
      .wrap(buildAwsValue())
}
object ListApplicationDependenciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesRequest =
      zio.aws.serverlessapplicationrepository.model
        .ListApplicationDependenciesRequest(
          applicationId,
          maxItems.map(value => value),
          nextToken.map(value => value),
          semanticVersion.map(value => value)
        )
    def applicationId: __string
    def maxItems: Option[MaxItems]
    def nextToken: Option[__string]
    def semanticVersion: Option[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getMaxItems: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSemanticVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("semanticVersion", semanticVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest
  ) extends zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.serverlessapplicationrepository.model.primitives
        .__string(impl.applicationId())
    override val maxItems: Option[MaxItems] = scala
      .Option(impl.maxItems())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.MaxItems(value)
      )
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val semanticVersion: Option[__string] = scala
      .Option(impl.semanticVersion())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest
  ): zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesRequest.ReadOnly =
    new Wrapper(impl)
}
