package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CreateCloudFormationChangeSetResponse(
    applicationId: Option[__string] = None,
    changeSetId: Option[__string] = None,
    semanticVersion: Option[__string] = None,
    stackId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse = {
    import CreateCloudFormationChangeSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse
      .builder()
      .optionallyWith(
        applicationId.map(value => __string.unwrap(value): java.lang.String)
      )(_.applicationId)
      .optionallyWith(
        changeSetId.map(value => __string.unwrap(value): java.lang.String)
      )(_.changeSetId)
      .optionallyWith(
        semanticVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.semanticVersion)
      .optionallyWith(
        stackId.map(value => __string.unwrap(value): java.lang.String)
      )(_.stackId)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse
      .wrap(buildAwsValue())
}
object CreateCloudFormationChangeSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse =
      zio.aws.serverlessapplicationrepository.model
        .CreateCloudFormationChangeSetResponse(
          applicationId.map(value => value),
          changeSetId.map(value => value),
          semanticVersion.map(value => value),
          stackId.map(value => value)
        )
    def applicationId: Option[__string]
    def changeSetId: Option[__string]
    def semanticVersion: Option[__string]
    def stackId: Option[__string]
    def getApplicationId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getChangeSetId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("changeSetId", changeSetId)
    def getSemanticVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("semanticVersion", semanticVersion)
    def getStackId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("stackId", stackId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse
  ) extends zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse.ReadOnly {
    override val applicationId: Option[__string] = scala
      .Option(impl.applicationId())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val changeSetId: Option[__string] = scala
      .Option(impl.changeSetId())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val semanticVersion: Option[__string] = scala
      .Option(impl.semanticVersion())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val stackId: Option[__string] = scala
      .Option(impl.stackId())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse
  ): zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse.ReadOnly =
    new Wrapper(impl)
}
