package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.{
  __boolean,
  __string
}
import scala.jdk.CollectionConverters.*
final case class CreateApplicationVersionResponse(
    applicationId: Option[__string] = None,
    creationTime: Option[__string] = None,
    parameterDefinitions: Option[Iterable[
      zio.aws.serverlessapplicationrepository.model.ParameterDefinition
    ]] = None,
    requiredCapabilities: Option[
      Iterable[zio.aws.serverlessapplicationrepository.model.Capability]
    ] = None,
    resourcesSupported: Option[__boolean] = None,
    semanticVersion: Option[__string] = None,
    sourceCodeArchiveUrl: Option[__string] = None,
    sourceCodeUrl: Option[__string] = None,
    templateUrl: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionResponse = {
    import CreateApplicationVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionResponse
      .builder()
      .optionallyWith(
        applicationId.map(value => __string.unwrap(value): java.lang.String)
      )(_.applicationId)
      .optionallyWith(
        creationTime.map(value => __string.unwrap(value): java.lang.String)
      )(_.creationTime)
      .optionallyWith(
        parameterDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterDefinitions)
      .optionallyWith(
        requiredCapabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.requiredCapabilitiesWithStrings)
      .optionallyWith(
        resourcesSupported.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.resourcesSupported)
      .optionallyWith(
        semanticVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.semanticVersion)
      .optionallyWith(
        sourceCodeArchiveUrl.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.sourceCodeArchiveUrl)
      .optionallyWith(
        sourceCodeUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.sourceCodeUrl)
      .optionallyWith(
        templateUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.templateUrl)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionResponse.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionResponse
      .wrap(buildAwsValue())
}
object CreateApplicationVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionResponse =
      zio.aws.serverlessapplicationrepository.model
        .CreateApplicationVersionResponse(
          applicationId.map(value => value),
          creationTime.map(value => value),
          parameterDefinitions.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          requiredCapabilities.map(value => value),
          resourcesSupported.map(value => value),
          semanticVersion.map(value => value),
          sourceCodeArchiveUrl.map(value => value),
          sourceCodeUrl.map(value => value),
          templateUrl.map(value => value)
        )
    def applicationId: Option[__string]
    def creationTime: Option[__string]
    def parameterDefinitions: Option[List[
      zio.aws.serverlessapplicationrepository.model.ParameterDefinition.ReadOnly
    ]]
    def requiredCapabilities
        : Option[List[zio.aws.serverlessapplicationrepository.model.Capability]]
    def resourcesSupported: Option[__boolean]
    def semanticVersion: Option[__string]
    def sourceCodeArchiveUrl: Option[__string]
    def sourceCodeUrl: Option[__string]
    def templateUrl: Option[__string]
    def getApplicationId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getCreationTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getParameterDefinitions: ZIO[Any, AwsError, List[
      zio.aws.serverlessapplicationrepository.model.ParameterDefinition.ReadOnly
    ]] =
      AwsError.unwrapOptionField("parameterDefinitions", parameterDefinitions)
    def getRequiredCapabilities: ZIO[Any, AwsError, List[
      zio.aws.serverlessapplicationrepository.model.Capability
    ]] =
      AwsError.unwrapOptionField("requiredCapabilities", requiredCapabilities)
    def getResourcesSupported: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("resourcesSupported", resourcesSupported)
    def getSemanticVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("semanticVersion", semanticVersion)
    def getSourceCodeArchiveUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceCodeArchiveUrl", sourceCodeArchiveUrl)
    def getSourceCodeUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceCodeUrl", sourceCodeUrl)
    def getTemplateUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateUrl", templateUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionResponse
  ) extends zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionResponse.ReadOnly {
    override val applicationId: Option[__string] = scala
      .Option(impl.applicationId())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val creationTime: Option[__string] = scala
      .Option(impl.creationTime())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val parameterDefinitions: Option[List[
      zio.aws.serverlessapplicationrepository.model.ParameterDefinition.ReadOnly
    ]] = scala
      .Option(impl.parameterDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.ParameterDefinition
            .wrap(item)
        }.toList
      )
    override val requiredCapabilities: Option[
      List[zio.aws.serverlessapplicationrepository.model.Capability]
    ] = scala
      .Option(impl.requiredCapabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.Capability.wrap(item)
        }.toList
      )
    override val resourcesSupported: Option[__boolean] = scala
      .Option(impl.resourcesSupported())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives
          .__boolean(value)
      )
    override val semanticVersion: Option[__string] = scala
      .Option(impl.semanticVersion())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val sourceCodeArchiveUrl: Option[__string] = scala
      .Option(impl.sourceCodeArchiveUrl())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val sourceCodeUrl: Option[__string] = scala
      .Option(impl.sourceCodeUrl())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val templateUrl: Option[__string] = scala
      .Option(impl.templateUrl())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionResponse
  ): zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionResponse.ReadOnly =
    new Wrapper(impl)
}
