package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ApplicationDependencySummary(
    applicationId: __string,
    semanticVersion: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationDependencySummary = {
    import ApplicationDependencySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationDependencySummary
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .semanticVersion(__string.unwrap(semanticVersion): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.ApplicationDependencySummary.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.ApplicationDependencySummary
      .wrap(buildAwsValue())
}
object ApplicationDependencySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationDependencySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.ApplicationDependencySummary =
      zio.aws.serverlessapplicationrepository.model
        .ApplicationDependencySummary(applicationId, semanticVersion)
    def applicationId: __string
    def semanticVersion: __string
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getSemanticVersion: ZIO[Any, Nothing, __string] =
      ZIO.succeed(semanticVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationDependencySummary
  ) extends zio.aws.serverlessapplicationrepository.model.ApplicationDependencySummary.ReadOnly {
    override val applicationId: __string =
      zio.aws.serverlessapplicationrepository.model.primitives
        .__string(impl.applicationId())
    override val semanticVersion: __string =
      zio.aws.serverlessapplicationrepository.model.primitives
        .__string(impl.semanticVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationDependencySummary
  ): zio.aws.serverlessapplicationrepository.model.ApplicationDependencySummary.ReadOnly =
    new Wrapper(impl)
}
