package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class CreateCloudFormationChangeSetRequest(
    applicationId: __string,
    capabilities: Optional[Iterable[__string]] = Optional.Absent,
    changeSetName: Optional[__string] = Optional.Absent,
    clientToken: Optional[__string] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    notificationArns: Optional[Iterable[__string]] = Optional.Absent,
    parameterOverrides: Optional[
      Iterable[zio.aws.serverlessapplicationrepository.model.ParameterValue]
    ] = Optional.Absent,
    resourceTypes: Optional[Iterable[__string]] = Optional.Absent,
    rollbackConfiguration: Optional[
      zio.aws.serverlessapplicationrepository.model.RollbackConfiguration
    ] = Optional.Absent,
    semanticVersion: Optional[__string] = Optional.Absent,
    stackName: __string,
    tags: Optional[
      Iterable[zio.aws.serverlessapplicationrepository.model.Tag]
    ] = Optional.Absent,
    templateId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest = {
    import CreateCloudFormationChangeSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest
      .builder()
      .applicationId(applicationId: java.lang.String)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.capabilities)
      .optionallyWith(changeSetName.map(value => value: java.lang.String))(
        _.changeSetName
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        notificationArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.notificationArns)
      .optionallyWith(
        parameterOverrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterOverrides)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .optionallyWith(
        rollbackConfiguration.map(value => value.buildAwsValue())
      )(_.rollbackConfiguration)
      .optionallyWith(semanticVersion.map(value => value: java.lang.String))(
        _.semanticVersion
      )
      .stackName(stackName: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(templateId.map(value => value: java.lang.String))(
        _.templateId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest
      .wrap(buildAwsValue())
}
object CreateCloudFormationChangeSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest =
      zio.aws.serverlessapplicationrepository.model
        .CreateCloudFormationChangeSetRequest(
          applicationId,
          capabilities.map(value => value),
          changeSetName.map(value => value),
          clientToken.map(value => value),
          description.map(value => value),
          notificationArns.map(value => value),
          parameterOverrides.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          resourceTypes.map(value => value),
          rollbackConfiguration.map(value => value.asEditable),
          semanticVersion.map(value => value),
          stackName,
          tags.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          templateId.map(value => value)
        )
    def applicationId: __string
    def capabilities: Optional[List[__string]]
    def changeSetName: Optional[__string]
    def clientToken: Optional[__string]
    def description: Optional[__string]
    def notificationArns: Optional[List[__string]]
    def parameterOverrides: Optional[List[
      zio.aws.serverlessapplicationrepository.model.ParameterValue.ReadOnly
    ]]
    def resourceTypes: Optional[List[__string]]
    def rollbackConfiguration: Optional[
      zio.aws.serverlessapplicationrepository.model.RollbackConfiguration.ReadOnly
    ]
    def semanticVersion: Optional[__string]
    def stackName: __string
    def tags: Optional[
      List[zio.aws.serverlessapplicationrepository.model.Tag.ReadOnly]
    ]
    def templateId: Optional[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getCapabilities: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getChangeSetName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("changeSetName", changeSetName)
    def getClientToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getNotificationArns: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("notificationArns", notificationArns)
    def getParameterOverrides: ZIO[Any, AwsError, List[
      zio.aws.serverlessapplicationrepository.model.ParameterValue.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterOverrides", parameterOverrides)
    def getResourceTypes: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
    def getRollbackConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.serverlessapplicationrepository.model.RollbackConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("rollbackConfiguration", rollbackConfiguration)
    def getSemanticVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("semanticVersion", semanticVersion)
    def getStackName: ZIO[Any, Nothing, __string] = ZIO.succeed(stackName)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.serverlessapplicationrepository.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getTemplateId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateId", templateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest
  ) extends zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val capabilities: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.capabilities())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val changeSetName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.changeSetName())
      .map(value => value: __string)
    override val clientToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: __string)
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val notificationArns: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationArns())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
    override val parameterOverrides: Optional[List[
      zio.aws.serverlessapplicationrepository.model.ParameterValue.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterOverrides())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.ParameterValue
            .wrap(item)
        }.toList
      )
    override val resourceTypes: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceTypes())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val rollbackConfiguration: Optional[
      zio.aws.serverlessapplicationrepository.model.RollbackConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rollbackConfiguration())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.RollbackConfiguration
          .wrap(value)
      )
    override val semanticVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.semanticVersion())
      .map(value => value: __string)
    override val stackName: __string = impl.stackName(): __string
    override val tags: Optional[
      List[zio.aws.serverlessapplicationrepository.model.Tag.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.Tag.wrap(item)
        }.toList
      )
    override val templateId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest
  ): zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest.ReadOnly =
    new Wrapper(impl)
}
