package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class VersionSummary(
    applicationId: __string,
    creationTime: __string,
    semanticVersion: __string,
    sourceCodeUrl: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.VersionSummary = {
    import VersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.VersionSummary
      .builder()
      .applicationId(applicationId: java.lang.String)
      .creationTime(creationTime: java.lang.String)
      .semanticVersion(semanticVersion: java.lang.String)
      .optionallyWith(sourceCodeUrl.map(value => value: java.lang.String))(
        _.sourceCodeUrl
      )
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.VersionSummary.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.VersionSummary
      .wrap(buildAwsValue())
}
object VersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.VersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.VersionSummary =
      zio.aws.serverlessapplicationrepository.model.VersionSummary(
        applicationId,
        creationTime,
        semanticVersion,
        sourceCodeUrl.map(value => value)
      )
    def applicationId: __string
    def creationTime: __string
    def semanticVersion: __string
    def sourceCodeUrl: Optional[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getCreationTime: ZIO[Any, Nothing, __string] = ZIO.succeed(creationTime)
    def getSemanticVersion: ZIO[Any, Nothing, __string] =
      ZIO.succeed(semanticVersion)
    def getSourceCodeUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceCodeUrl", sourceCodeUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.VersionSummary
  ) extends zio.aws.serverlessapplicationrepository.model.VersionSummary.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val creationTime: __string = impl.creationTime(): __string
    override val semanticVersion: __string = impl.semanticVersion(): __string
    override val sourceCodeUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceCodeUrl())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.VersionSummary
  ): zio.aws.serverlessapplicationrepository.model.VersionSummary.ReadOnly =
    new Wrapper(impl)
}
