package zio.aws.serverlessapplicationrepository.model
import zio.aws.serverlessapplicationrepository.model.primitives.__integer
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RollbackConfiguration(
    monitoringTimeInMinutes: Optional[__integer] = Optional.Absent,
    rollbackTriggers: Optional[
      Iterable[zio.aws.serverlessapplicationrepository.model.RollbackTrigger]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.RollbackConfiguration = {
    import RollbackConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.RollbackConfiguration
      .builder()
      .optionallyWith(monitoringTimeInMinutes.map(value => value: Integer))(
        _.monitoringTimeInMinutes
      )
      .optionallyWith(
        rollbackTriggers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rollbackTriggers)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.RollbackConfiguration.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.RollbackConfiguration
      .wrap(buildAwsValue())
}
object RollbackConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.RollbackConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.RollbackConfiguration =
      zio.aws.serverlessapplicationrepository.model.RollbackConfiguration(
        monitoringTimeInMinutes.map(value => value),
        rollbackTriggers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def monitoringTimeInMinutes: Optional[__integer]
    def rollbackTriggers: Optional[List[
      zio.aws.serverlessapplicationrepository.model.RollbackTrigger.ReadOnly
    ]]
    def getMonitoringTimeInMinutes: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("monitoringTimeInMinutes", monitoringTimeInMinutes)
    def getRollbackTriggers: ZIO[Any, AwsError, List[
      zio.aws.serverlessapplicationrepository.model.RollbackTrigger.ReadOnly
    ]] = AwsError.unwrapOptionField("rollbackTriggers", rollbackTriggers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.RollbackConfiguration
  ) extends zio.aws.serverlessapplicationrepository.model.RollbackConfiguration.ReadOnly {
    override val monitoringTimeInMinutes: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringTimeInMinutes())
        .map(value => value: __integer)
    override val rollbackTriggers: Optional[List[
      zio.aws.serverlessapplicationrepository.model.RollbackTrigger.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.rollbackTriggers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.RollbackTrigger
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.RollbackConfiguration
  ): zio.aws.serverlessapplicationrepository.model.RollbackConfiguration.ReadOnly =
    new Wrapper(impl)
}
