package zio.aws.serverlessapplicationrepository
import zio.aws.serverlessapplicationrepository.model.UpdateApplicationResponse.ReadOnly
import software.amazon.awssdk.services.serverlessapplicationrepository.ServerlessApplicationRepositoryAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.serverlessapplicationrepository.model.{
  UpdateApplicationRequest,
  PutApplicationPolicyRequest,
  DeleteApplicationRequest,
  CreateCloudFormationChangeSetRequest,
  CreateApplicationVersionRequest,
  CreateApplicationRequest,
  GetCloudFormationTemplateRequest,
  ListApplicationDependenciesRequest,
  GetApplicationPolicyRequest,
  GetApplicationRequest,
  ListApplicationsRequest,
  UnshareApplicationRequest,
  ListApplicationVersionsRequest,
  CreateCloudFormationTemplateRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object ServerlessApplicationRepositoryMock
    extends Mock[ServerlessApplicationRepository] {
  object GetApplication
      extends Effect[
        GetApplicationRequest,
        AwsError,
        zio.aws.serverlessapplicationrepository.model.GetApplicationResponse.ReadOnly
      ]
  object DeleteApplication
      extends Effect[DeleteApplicationRequest, AwsError, Unit]
  object GetCloudFormationTemplate
      extends Effect[
        GetCloudFormationTemplateRequest,
        AwsError,
        zio.aws.serverlessapplicationrepository.model.GetCloudFormationTemplateResponse.ReadOnly
      ]
  object ListApplicationDependencies
      extends Stream[
        ListApplicationDependenciesRequest,
        AwsError,
        zio.aws.serverlessapplicationrepository.model.ApplicationDependencySummary.ReadOnly
      ]
  object ListApplicationDependenciesPaginated
      extends Effect[
        ListApplicationDependenciesRequest,
        AwsError,
        zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesResponse.ReadOnly
      ]
  object PutApplicationPolicy
      extends Effect[
        PutApplicationPolicyRequest,
        AwsError,
        zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyResponse.ReadOnly
      ]
  object CreateApplicationVersion
      extends Effect[
        CreateApplicationVersionRequest,
        AwsError,
        zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionResponse.ReadOnly
      ]
  object CreateApplication
      extends Effect[
        CreateApplicationRequest,
        AwsError,
        zio.aws.serverlessapplicationrepository.model.CreateApplicationResponse.ReadOnly
      ]
  object CreateCloudFormationChangeSet
      extends Effect[
        CreateCloudFormationChangeSetRequest,
        AwsError,
        zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse.ReadOnly
      ]
  object UnshareApplication
      extends Effect[UnshareApplicationRequest, AwsError, Unit]
  object ListApplications
      extends Stream[
        ListApplicationsRequest,
        AwsError,
        zio.aws.serverlessapplicationrepository.model.ApplicationSummary.ReadOnly
      ]
  object ListApplicationsPaginated
      extends Effect[
        ListApplicationsRequest,
        AwsError,
        zio.aws.serverlessapplicationrepository.model.ListApplicationsResponse.ReadOnly
      ]
  object UpdateApplication
      extends Effect[UpdateApplicationRequest, AwsError, ReadOnly]
  object ListApplicationVersions
      extends Stream[
        ListApplicationVersionsRequest,
        AwsError,
        zio.aws.serverlessapplicationrepository.model.VersionSummary.ReadOnly
      ]
  object ListApplicationVersionsPaginated
      extends Effect[
        ListApplicationVersionsRequest,
        AwsError,
        zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsResponse.ReadOnly
      ]
  object CreateCloudFormationTemplate
      extends Effect[
        CreateCloudFormationTemplateRequest,
        AwsError,
        zio.aws.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse.ReadOnly
      ]
  object GetApplicationPolicy
      extends Effect[
        GetApplicationPolicyRequest,
        AwsError,
        zio.aws.serverlessapplicationrepository.model.GetApplicationPolicyResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ServerlessApplicationRepository] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, ServerlessApplicationRepository] { rts =>
        zio.ZIO.succeed {
          new ServerlessApplicationRepository {
            val api: ServerlessApplicationRepositoryAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): ServerlessApplicationRepository = this
            def getApplication(request: GetApplicationRequest): IO[
              AwsError,
              zio.aws.serverlessapplicationrepository.model.GetApplicationResponse.ReadOnly
            ] = proxy(GetApplication, request)
            def deleteApplication(
                request: DeleteApplicationRequest
            ): IO[AwsError, Unit] = proxy(DeleteApplication, request)
            def getCloudFormationTemplate(
                request: GetCloudFormationTemplateRequest
            ): IO[
              AwsError,
              zio.aws.serverlessapplicationrepository.model.GetCloudFormationTemplateResponse.ReadOnly
            ] = proxy(GetCloudFormationTemplate, request)
            def listApplicationDependencies(
                request: ListApplicationDependenciesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.serverlessapplicationrepository.model.ApplicationDependencySummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListApplicationDependencies, request)
                }
                .getOrThrowFiberFailure()
            }
            def listApplicationDependenciesPaginated(
                request: ListApplicationDependenciesRequest
            ): IO[
              AwsError,
              zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesResponse.ReadOnly
            ] = proxy(ListApplicationDependenciesPaginated, request)
            def putApplicationPolicy(request: PutApplicationPolicyRequest): IO[
              AwsError,
              zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyResponse.ReadOnly
            ] = proxy(PutApplicationPolicy, request)
            def createApplicationVersion(
                request: CreateApplicationVersionRequest
            ): IO[
              AwsError,
              zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionResponse.ReadOnly
            ] = proxy(CreateApplicationVersion, request)
            def createApplication(request: CreateApplicationRequest): IO[
              AwsError,
              zio.aws.serverlessapplicationrepository.model.CreateApplicationResponse.ReadOnly
            ] = proxy(CreateApplication, request)
            def createCloudFormationChangeSet(
                request: CreateCloudFormationChangeSetRequest
            ): IO[
              AwsError,
              zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse.ReadOnly
            ] = proxy(CreateCloudFormationChangeSet, request)
            def unshareApplication(
                request: UnshareApplicationRequest
            ): IO[AwsError, Unit] = proxy(UnshareApplication, request)
            def listApplications(request: ListApplicationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.serverlessapplicationrepository.model.ApplicationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListApplications, request)
                }
                .getOrThrowFiberFailure()
            }
            def listApplicationsPaginated(request: ListApplicationsRequest): IO[
              AwsError,
              zio.aws.serverlessapplicationrepository.model.ListApplicationsResponse.ReadOnly
            ] = proxy(ListApplicationsPaginated, request)
            def updateApplication(
                request: UpdateApplicationRequest
            ): IO[AwsError, ReadOnly] = proxy(UpdateApplication, request)
            def listApplicationVersions(
                request: ListApplicationVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.serverlessapplicationrepository.model.VersionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListApplicationVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listApplicationVersionsPaginated(
                request: ListApplicationVersionsRequest
            ): IO[
              AwsError,
              zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsResponse.ReadOnly
            ] = proxy(ListApplicationVersionsPaginated, request)
            def createCloudFormationTemplate(
                request: CreateCloudFormationTemplateRequest
            ): IO[
              AwsError,
              zio.aws.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse.ReadOnly
            ] = proxy(CreateCloudFormationTemplate, request)
            def getApplicationPolicy(request: GetApplicationPolicyRequest): IO[
              AwsError,
              zio.aws.serverlessapplicationrepository.model.GetApplicationPolicyResponse.ReadOnly
            ] = proxy(GetApplicationPolicy, request)
          }
        }
      }
    }
  }
}
