package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ApplicationSummary(
    applicationId: __string,
    author: __string,
    creationTime: Optional[__string] = Optional.Absent,
    description: __string,
    homePageUrl: Optional[__string] = Optional.Absent,
    labels: Optional[Iterable[__string]] = Optional.Absent,
    name: __string,
    spdxLicenseId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationSummary = {
    import ApplicationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationSummary
      .builder()
      .applicationId(applicationId: java.lang.String)
      .author(author: java.lang.String)
      .optionallyWith(creationTime.map(value => value: java.lang.String))(
        _.creationTime
      )
      .description(description: java.lang.String)
      .optionallyWith(homePageUrl.map(value => value: java.lang.String))(
        _.homePageUrl
      )
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.labels)
      .name(name: java.lang.String)
      .optionallyWith(spdxLicenseId.map(value => value: java.lang.String))(
        _.spdxLicenseId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.ApplicationSummary.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.ApplicationSummary
      .wrap(buildAwsValue())
}
object ApplicationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.ApplicationSummary =
      zio.aws.serverlessapplicationrepository.model.ApplicationSummary(
        applicationId,
        author,
        creationTime.map(value => value),
        description,
        homePageUrl.map(value => value),
        labels.map(value => value),
        name,
        spdxLicenseId.map(value => value)
      )
    def applicationId: __string
    def author: __string
    def creationTime: Optional[__string]
    def description: __string
    def homePageUrl: Optional[__string]
    def labels: Optional[List[__string]]
    def name: __string
    def spdxLicenseId: Optional[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getAuthor: ZIO[Any, Nothing, __string] = ZIO.succeed(author)
    def getCreationTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDescription: ZIO[Any, Nothing, __string] = ZIO.succeed(description)
    def getHomePageUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("homePageUrl", homePageUrl)
    def getLabels: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("labels", labels)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getSpdxLicenseId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("spdxLicenseId", spdxLicenseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationSummary
  ) extends zio.aws.serverlessapplicationrepository.model.ApplicationSummary.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val author: __string = impl.author(): __string
    override val creationTime: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => value: __string)
    override val description: __string = impl.description(): __string
    override val homePageUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.homePageUrl())
      .map(value => value: __string)
    override val labels: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val name: __string = impl.name(): __string
    override val spdxLicenseId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.spdxLicenseId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationSummary
  ): zio.aws.serverlessapplicationrepository.model.ApplicationSummary.ReadOnly =
    new Wrapper(impl)
}
