package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class GetCloudFormationTemplateResponse(
    applicationId: Optional[__string] = Optional.Absent,
    creationTime: Optional[__string] = Optional.Absent,
    expirationTime: Optional[__string] = Optional.Absent,
    semanticVersion: Optional[__string] = Optional.Absent,
    status: Optional[zio.aws.serverlessapplicationrepository.model.Status] =
      Optional.Absent,
    templateId: Optional[__string] = Optional.Absent,
    templateUrl: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.GetCloudFormationTemplateResponse = {
    import GetCloudFormationTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.GetCloudFormationTemplateResponse
      .builder()
      .optionallyWith(applicationId.map(value => value: java.lang.String))(
        _.applicationId
      )
      .optionallyWith(creationTime.map(value => value: java.lang.String))(
        _.creationTime
      )
      .optionallyWith(expirationTime.map(value => value: java.lang.String))(
        _.expirationTime
      )
      .optionallyWith(semanticVersion.map(value => value: java.lang.String))(
        _.semanticVersion
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(templateId.map(value => value: java.lang.String))(
        _.templateId
      )
      .optionallyWith(templateUrl.map(value => value: java.lang.String))(
        _.templateUrl
      )
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.GetCloudFormationTemplateResponse.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.GetCloudFormationTemplateResponse
      .wrap(buildAwsValue())
}
object GetCloudFormationTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.GetCloudFormationTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.GetCloudFormationTemplateResponse =
      zio.aws.serverlessapplicationrepository.model
        .GetCloudFormationTemplateResponse(
          applicationId.map(value => value),
          creationTime.map(value => value),
          expirationTime.map(value => value),
          semanticVersion.map(value => value),
          status.map(value => value),
          templateId.map(value => value),
          templateUrl.map(value => value)
        )
    def applicationId: Optional[__string]
    def creationTime: Optional[__string]
    def expirationTime: Optional[__string]
    def semanticVersion: Optional[__string]
    def status: Optional[zio.aws.serverlessapplicationrepository.model.Status]
    def templateId: Optional[__string]
    def templateUrl: Optional[__string]
    def getApplicationId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getCreationTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getExpirationTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("expirationTime", expirationTime)
    def getSemanticVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("semanticVersion", semanticVersion)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.serverlessapplicationrepository.model.Status
    ] = AwsError.unwrapOptionField("status", status)
    def getTemplateId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateId", templateId)
    def getTemplateUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateUrl", templateUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.GetCloudFormationTemplateResponse
  ) extends zio.aws.serverlessapplicationrepository.model.GetCloudFormationTemplateResponse.ReadOnly {
    override val applicationId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => value: __string)
    override val creationTime: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => value: __string)
    override val expirationTime: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationTime())
      .map(value => value: __string)
    override val semanticVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.semanticVersion())
      .map(value => value: __string)
    override val status
        : Optional[zio.aws.serverlessapplicationrepository.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.serverlessapplicationrepository.model.Status.wrap(value)
        )
    override val templateId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateId())
      .map(value => value: __string)
    override val templateUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateUrl())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.GetCloudFormationTemplateResponse
  ): zio.aws.serverlessapplicationrepository.model.GetCloudFormationTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
