package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.serverlessapplicationrepository.model.primitives.{
  __boolean,
  __string
}
import scala.jdk.CollectionConverters._
final case class UpdateApplicationResponse(
    applicationId: Optional[__string] = Optional.Absent,
    author: Optional[__string] = Optional.Absent,
    creationTime: Optional[__string] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    homePageUrl: Optional[__string] = Optional.Absent,
    isVerifiedAuthor: Optional[__boolean] = Optional.Absent,
    labels: Optional[Iterable[__string]] = Optional.Absent,
    licenseUrl: Optional[__string] = Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    readmeUrl: Optional[__string] = Optional.Absent,
    spdxLicenseId: Optional[__string] = Optional.Absent,
    verifiedAuthorUrl: Optional[__string] = Optional.Absent,
    version: Optional[zio.aws.serverlessapplicationrepository.model.Version] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.UpdateApplicationResponse = {
    import UpdateApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.UpdateApplicationResponse
      .builder()
      .optionallyWith(applicationId.map(value => value: java.lang.String))(
        _.applicationId
      )
      .optionallyWith(author.map(value => value: java.lang.String))(_.author)
      .optionallyWith(creationTime.map(value => value: java.lang.String))(
        _.creationTime
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(homePageUrl.map(value => value: java.lang.String))(
        _.homePageUrl
      )
      .optionallyWith(isVerifiedAuthor.map(value => value: java.lang.Boolean))(
        _.isVerifiedAuthor
      )
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(licenseUrl.map(value => value: java.lang.String))(
        _.licenseUrl
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(readmeUrl.map(value => value: java.lang.String))(
        _.readmeUrl
      )
      .optionallyWith(spdxLicenseId.map(value => value: java.lang.String))(
        _.spdxLicenseId
      )
      .optionallyWith(verifiedAuthorUrl.map(value => value: java.lang.String))(
        _.verifiedAuthorUrl
      )
      .optionallyWith(version.map(value => value.buildAwsValue()))(_.version)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.UpdateApplicationResponse.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.UpdateApplicationResponse
      .wrap(buildAwsValue())
}
object UpdateApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.UpdateApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.UpdateApplicationResponse =
      zio.aws.serverlessapplicationrepository.model.UpdateApplicationResponse(
        applicationId.map(value => value),
        author.map(value => value),
        creationTime.map(value => value),
        description.map(value => value),
        homePageUrl.map(value => value),
        isVerifiedAuthor.map(value => value),
        labels.map(value => value),
        licenseUrl.map(value => value),
        name.map(value => value),
        readmeUrl.map(value => value),
        spdxLicenseId.map(value => value),
        verifiedAuthorUrl.map(value => value),
        version.map(value => value.asEditable)
      )
    def applicationId: Optional[__string]
    def author: Optional[__string]
    def creationTime: Optional[__string]
    def description: Optional[__string]
    def homePageUrl: Optional[__string]
    def isVerifiedAuthor: Optional[__boolean]
    def labels: Optional[List[__string]]
    def licenseUrl: Optional[__string]
    def name: Optional[__string]
    def readmeUrl: Optional[__string]
    def spdxLicenseId: Optional[__string]
    def verifiedAuthorUrl: Optional[__string]
    def version: Optional[
      zio.aws.serverlessapplicationrepository.model.Version.ReadOnly
    ]
    def getApplicationId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getAuthor: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("author", author)
    def getCreationTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getHomePageUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("homePageUrl", homePageUrl)
    def getIsVerifiedAuthor: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("isVerifiedAuthor", isVerifiedAuthor)
    def getLabels: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("labels", labels)
    def getLicenseUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("licenseUrl", licenseUrl)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getReadmeUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("readmeUrl", readmeUrl)
    def getSpdxLicenseId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("spdxLicenseId", spdxLicenseId)
    def getVerifiedAuthorUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("verifiedAuthorUrl", verifiedAuthorUrl)
    def getVersion: ZIO[
      Any,
      AwsError,
      zio.aws.serverlessapplicationrepository.model.Version.ReadOnly
    ] = AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.UpdateApplicationResponse
  ) extends zio.aws.serverlessapplicationrepository.model.UpdateApplicationResponse.ReadOnly {
    override val applicationId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => value: __string)
    override val author: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.author())
      .map(value => value: __string)
    override val creationTime: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => value: __string)
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val homePageUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.homePageUrl())
      .map(value => value: __string)
    override val isVerifiedAuthor: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isVerifiedAuthor())
      .map(value => value: __boolean)
    override val labels: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val licenseUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseUrl())
      .map(value => value: __string)
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val readmeUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.readmeUrl())
      .map(value => value: __string)
    override val spdxLicenseId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.spdxLicenseId())
      .map(value => value: __string)
    override val verifiedAuthorUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.verifiedAuthorUrl())
      .map(value => value: __string)
    override val version: Optional[
      zio.aws.serverlessapplicationrepository.model.Version.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.Version.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.UpdateApplicationResponse
  ): zio.aws.serverlessapplicationrepository.model.UpdateApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
