package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ApplicationPolicyStatement(
    actions: Iterable[__string],
    principalOrgIDs: Optional[Iterable[__string]] = Optional.Absent,
    principals: Iterable[__string],
    statementId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationPolicyStatement = {
    import ApplicationPolicyStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationPolicyStatement
      .builder()
      .actions(actions.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        principalOrgIDs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.principalOrgIDs)
      .principals(principals.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(statementId.map(value => value: java.lang.String))(
        _.statementId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement
      .wrap(buildAwsValue())
}
object ApplicationPolicyStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationPolicyStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement =
      zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement(
        actions,
        principalOrgIDs.map(value => value),
        principals,
        statementId.map(value => value)
      )
    def actions: List[__string]
    def principalOrgIDs: Optional[List[__string]]
    def principals: List[__string]
    def statementId: Optional[__string]
    def getActions: ZIO[Any, Nothing, List[__string]] = ZIO.succeed(actions)
    def getPrincipalOrgIDs: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("principalOrgIDs", principalOrgIDs)
    def getPrincipals: ZIO[Any, Nothing, List[__string]] =
      ZIO.succeed(principals)
    def getStatementId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("statementId", statementId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationPolicyStatement
  ) extends zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement.ReadOnly {
    override val actions: List[__string] = impl
      .actions()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
    override val principalOrgIDs: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principalOrgIDs())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
    override val principals: List[__string] = impl
      .principals()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
    override val statementId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.statementId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationPolicyStatement
  ): zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement.ReadOnly =
    new Wrapper(impl)
}
