package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutApplicationPolicyResponse(
    statements: Optional[Iterable[
      zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.PutApplicationPolicyResponse = {
    import PutApplicationPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.PutApplicationPolicyResponse
      .builder()
      .optionallyWith(
        statements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statements)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyResponse.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyResponse
      .wrap(buildAwsValue())
}
object PutApplicationPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.PutApplicationPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyResponse =
      zio.aws.serverlessapplicationrepository.model
        .PutApplicationPolicyResponse(
          statements.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def statements: Optional[List[
      zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement.ReadOnly
    ]]
    def getStatements: ZIO[Any, AwsError, List[
      zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement.ReadOnly
    ]] = AwsError.unwrapOptionField("statements", statements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.PutApplicationPolicyResponse
  ) extends zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyResponse.ReadOnly {
    override val statements: Optional[List[
      zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.statements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.PutApplicationPolicyResponse
  ): zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
