package zio.aws.serverlessapplicationrepository.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.{
  MaxItems,
  __string
}
import scala.jdk.CollectionConverters._
final case class ListApplicationVersionsRequest(
    applicationId: __string,
    maxItems: Option[MaxItems] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest = {
    import ListApplicationVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest
      .builder()
      .applicationId(applicationId: java.lang.String)
      .optionallyWith(maxItems.map(value => MaxItems.unwrap(value): Integer))(
        _.maxItems
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsRequest.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsRequest
      .wrap(buildAwsValue())
}
object ListApplicationVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsRequest =
      zio.aws.serverlessapplicationrepository.model
        .ListApplicationVersionsRequest(
          applicationId,
          maxItems.map(value => value),
          nextToken.map(value => value)
        )
    def applicationId: __string
    def maxItems: Option[MaxItems]
    def nextToken: Option[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getMaxItems: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest
  ) extends zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsRequest.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val maxItems: Option[MaxItems] = scala
      .Option(impl.maxItems())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.MaxItems(value)
      )
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest
  ): zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
