package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListApplicationDependenciesResponse(
    dependencies: Option[Iterable[
      zio.aws.serverlessapplicationrepository.model.ApplicationDependencySummary
    ]] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesResponse = {
    import ListApplicationDependenciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesResponse
      .builder()
      .optionallyWith(
        dependencies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dependencies)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesResponse.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesResponse
      .wrap(buildAwsValue())
}
object ListApplicationDependenciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesResponse =
      zio.aws.serverlessapplicationrepository.model
        .ListApplicationDependenciesResponse(
          dependencies.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def dependencies: Option[List[
      zio.aws.serverlessapplicationrepository.model.ApplicationDependencySummary.ReadOnly
    ]]
    def nextToken: Option[__string]
    def getDependencies: ZIO[Any, AwsError, List[
      zio.aws.serverlessapplicationrepository.model.ApplicationDependencySummary.ReadOnly
    ]] = AwsError.unwrapOptionField("dependencies", dependencies)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesResponse
  ) extends zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesResponse.ReadOnly {
    override val dependencies: Option[List[
      zio.aws.serverlessapplicationrepository.model.ApplicationDependencySummary.ReadOnly
    ]] = scala
      .Option(impl.dependencies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.ApplicationDependencySummary
            .wrap(item)
        }.toList
      )
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesResponse
  ): zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesResponse.ReadOnly =
    new Wrapper(impl)
}
