package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class CreateCloudFormationTemplateRequest(
    applicationId: __string,
    semanticVersion: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateRequest = {
    import CreateCloudFormationTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        semanticVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.semanticVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.CreateCloudFormationTemplateRequest.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.CreateCloudFormationTemplateRequest
      .wrap(buildAwsValue())
}
object CreateCloudFormationTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.CreateCloudFormationTemplateRequest =
      zio.aws.serverlessapplicationrepository.model
        .CreateCloudFormationTemplateRequest(
          applicationId,
          semanticVersion.map(value => value)
        )
    def applicationId: __string
    def semanticVersion: Option[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getSemanticVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("semanticVersion", semanticVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateRequest
  ) extends zio.aws.serverlessapplicationrepository.model.CreateCloudFormationTemplateRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.serverlessapplicationrepository.model.primitives
        .__string(impl.applicationId())
    override val semanticVersion: Option[__string] = scala
      .Option(impl.semanticVersion())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateRequest
  ): zio.aws.serverlessapplicationrepository.model.CreateCloudFormationTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
