package zio.aws.serverlessapplicationrepository.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.__integer
import scala.jdk.CollectionConverters._
final case class RollbackConfiguration(
    monitoringTimeInMinutes: Option[__integer] = None,
    rollbackTriggers: Option[
      Iterable[zio.aws.serverlessapplicationrepository.model.RollbackTrigger]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.RollbackConfiguration = {
    import RollbackConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.RollbackConfiguration
      .builder()
      .optionallyWith(
        monitoringTimeInMinutes.map(value => __integer.unwrap(value): Integer)
      )(_.monitoringTimeInMinutes)
      .optionallyWith(
        rollbackTriggers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rollbackTriggers)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.RollbackConfiguration.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.RollbackConfiguration
      .wrap(buildAwsValue())
}
object RollbackConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.RollbackConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.RollbackConfiguration =
      zio.aws.serverlessapplicationrepository.model.RollbackConfiguration(
        monitoringTimeInMinutes.map(value => value),
        rollbackTriggers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def monitoringTimeInMinutes: Option[__integer]
    def rollbackTriggers: Option[List[
      zio.aws.serverlessapplicationrepository.model.RollbackTrigger.ReadOnly
    ]]
    def getMonitoringTimeInMinutes: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("monitoringTimeInMinutes", monitoringTimeInMinutes)
    def getRollbackTriggers: ZIO[Any, AwsError, List[
      zio.aws.serverlessapplicationrepository.model.RollbackTrigger.ReadOnly
    ]] = AwsError.unwrapOptionField("rollbackTriggers", rollbackTriggers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.RollbackConfiguration
  ) extends zio.aws.serverlessapplicationrepository.model.RollbackConfiguration.ReadOnly {
    override val monitoringTimeInMinutes: Option[__integer] = scala
      .Option(impl.monitoringTimeInMinutes())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives
          .__integer(value)
      )
    override val rollbackTriggers: Option[List[
      zio.aws.serverlessapplicationrepository.model.RollbackTrigger.ReadOnly
    ]] = scala
      .Option(impl.rollbackTriggers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.RollbackTrigger
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.RollbackConfiguration
  ): zio.aws.serverlessapplicationrepository.model.RollbackConfiguration.ReadOnly =
    new Wrapper(impl)
}
