package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class CreateApplicationVersionRequest(
    applicationId: __string,
    semanticVersion: __string,
    sourceCodeArchiveUrl: Option[__string] = None,
    sourceCodeUrl: Option[__string] = None,
    templateBody: Option[__string] = None,
    templateUrl: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionRequest = {
    import CreateApplicationVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .semanticVersion(__string.unwrap(semanticVersion): java.lang.String)
      .optionallyWith(
        sourceCodeArchiveUrl.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.sourceCodeArchiveUrl)
      .optionallyWith(
        sourceCodeUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.sourceCodeUrl)
      .optionallyWith(
        templateBody.map(value => __string.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        templateUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.templateUrl)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionRequest.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionRequest
      .wrap(buildAwsValue())
}
object CreateApplicationVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionRequest =
      zio.aws.serverlessapplicationrepository.model
        .CreateApplicationVersionRequest(
          applicationId,
          semanticVersion,
          sourceCodeArchiveUrl.map(value => value),
          sourceCodeUrl.map(value => value),
          templateBody.map(value => value),
          templateUrl.map(value => value)
        )
    def applicationId: __string
    def semanticVersion: __string
    def sourceCodeArchiveUrl: Option[__string]
    def sourceCodeUrl: Option[__string]
    def templateBody: Option[__string]
    def templateUrl: Option[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getSemanticVersion: ZIO[Any, Nothing, __string] =
      ZIO.succeed(semanticVersion)
    def getSourceCodeArchiveUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceCodeArchiveUrl", sourceCodeArchiveUrl)
    def getSourceCodeUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceCodeUrl", sourceCodeUrl)
    def getTemplateBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getTemplateUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateUrl", templateUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionRequest
  ) extends zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.serverlessapplicationrepository.model.primitives
        .__string(impl.applicationId())
    override val semanticVersion: __string =
      zio.aws.serverlessapplicationrepository.model.primitives
        .__string(impl.semanticVersion())
    override val sourceCodeArchiveUrl: Option[__string] = scala
      .Option(impl.sourceCodeArchiveUrl())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val sourceCodeUrl: Option[__string] = scala
      .Option(impl.sourceCodeUrl())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val templateBody: Option[__string] = scala
      .Option(impl.templateBody())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val templateUrl: Option[__string] = scala
      .Option(impl.templateUrl())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionRequest
  ): zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionRequest.ReadOnly =
    new Wrapper(impl)
}
