package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.{
  __boolean,
  __string
}
import scala.jdk.CollectionConverters._
final case class CreateApplicationResponse(
    applicationId: Option[__string] = None,
    author: Option[__string] = None,
    creationTime: Option[__string] = None,
    description: Option[__string] = None,
    homePageUrl: Option[__string] = None,
    isVerifiedAuthor: Option[__boolean] = None,
    labels: Option[Iterable[__string]] = None,
    licenseUrl: Option[__string] = None,
    name: Option[__string] = None,
    readmeUrl: Option[__string] = None,
    spdxLicenseId: Option[__string] = None,
    verifiedAuthorUrl: Option[__string] = None,
    version: Option[zio.aws.serverlessapplicationrepository.model.Version] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationResponse = {
    import CreateApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationResponse
      .builder()
      .optionallyWith(
        applicationId.map(value => __string.unwrap(value): java.lang.String)
      )(_.applicationId)
      .optionallyWith(
        author.map(value => __string.unwrap(value): java.lang.String)
      )(_.author)
      .optionallyWith(
        creationTime.map(value => __string.unwrap(value): java.lang.String)
      )(_.creationTime)
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        homePageUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.homePageUrl)
      .optionallyWith(
        isVerifiedAuthor.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.isVerifiedAuthor)
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(
        licenseUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.licenseUrl)
      .optionallyWith(
        name.map(value => __string.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        readmeUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.readmeUrl)
      .optionallyWith(
        spdxLicenseId.map(value => __string.unwrap(value): java.lang.String)
      )(_.spdxLicenseId)
      .optionallyWith(
        verifiedAuthorUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.verifiedAuthorUrl)
      .optionallyWith(version.map(value => value.buildAwsValue()))(_.version)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.CreateApplicationResponse.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.CreateApplicationResponse
      .wrap(buildAwsValue())
}
object CreateApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.CreateApplicationResponse =
      zio.aws.serverlessapplicationrepository.model.CreateApplicationResponse(
        applicationId.map(value => value),
        author.map(value => value),
        creationTime.map(value => value),
        description.map(value => value),
        homePageUrl.map(value => value),
        isVerifiedAuthor.map(value => value),
        labels.map(value => value),
        licenseUrl.map(value => value),
        name.map(value => value),
        readmeUrl.map(value => value),
        spdxLicenseId.map(value => value),
        verifiedAuthorUrl.map(value => value),
        version.map(value => value.asEditable)
      )
    def applicationId: Option[__string]
    def author: Option[__string]
    def creationTime: Option[__string]
    def description: Option[__string]
    def homePageUrl: Option[__string]
    def isVerifiedAuthor: Option[__boolean]
    def labels: Option[List[__string]]
    def licenseUrl: Option[__string]
    def name: Option[__string]
    def readmeUrl: Option[__string]
    def spdxLicenseId: Option[__string]
    def verifiedAuthorUrl: Option[__string]
    def version
        : Option[zio.aws.serverlessapplicationrepository.model.Version.ReadOnly]
    def getApplicationId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getAuthor: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("author", author)
    def getCreationTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getHomePageUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("homePageUrl", homePageUrl)
    def getIsVerifiedAuthor: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("isVerifiedAuthor", isVerifiedAuthor)
    def getLabels: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("labels", labels)
    def getLicenseUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("licenseUrl", licenseUrl)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getReadmeUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("readmeUrl", readmeUrl)
    def getSpdxLicenseId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("spdxLicenseId", spdxLicenseId)
    def getVerifiedAuthorUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("verifiedAuthorUrl", verifiedAuthorUrl)
    def getVersion: ZIO[
      Any,
      AwsError,
      zio.aws.serverlessapplicationrepository.model.Version.ReadOnly
    ] = AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationResponse
  ) extends zio.aws.serverlessapplicationrepository.model.CreateApplicationResponse.ReadOnly {
    override val applicationId: Option[__string] = scala
      .Option(impl.applicationId())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val author: Option[__string] = scala
      .Option(impl.author())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val creationTime: Option[__string] = scala
      .Option(impl.creationTime())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val homePageUrl: Option[__string] = scala
      .Option(impl.homePageUrl())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val isVerifiedAuthor: Option[__boolean] = scala
      .Option(impl.isVerifiedAuthor())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives
          .__boolean(value)
      )
    override val labels: Option[List[__string]] = scala
      .Option(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.primitives
            .__string(item)
        }.toList
      )
    override val licenseUrl: Option[__string] = scala
      .Option(impl.licenseUrl())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val name: Option[__string] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val readmeUrl: Option[__string] = scala
      .Option(impl.readmeUrl())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val spdxLicenseId: Option[__string] = scala
      .Option(impl.spdxLicenseId())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val verifiedAuthorUrl: Option[__string] = scala
      .Option(impl.verifiedAuthorUrl())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val version: Option[
      zio.aws.serverlessapplicationrepository.model.Version.ReadOnly
    ] = scala
      .Option(impl.version())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.Version.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationResponse
  ): zio.aws.serverlessapplicationrepository.model.CreateApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
