package zio.aws.serverlessapplicationrepository.model
import zio.aws.serverlessapplicationrepository.model.primitives.{
  MaxItems,
  __string
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListApplicationDependenciesRequest(
    applicationId: __string,
    maxItems: Optional[MaxItems] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent,
    semanticVersion: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest = {
    import ListApplicationDependenciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest
      .builder()
      .applicationId(applicationId: java.lang.String)
      .optionallyWith(maxItems.map(value => MaxItems.unwrap(value): Integer))(
        _.maxItems
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(semanticVersion.map(value => value: java.lang.String))(
        _.semanticVersion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesRequest.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesRequest
      .wrap(buildAwsValue())
}
object ListApplicationDependenciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesRequest =
      zio.aws.serverlessapplicationrepository.model
        .ListApplicationDependenciesRequest(
          applicationId,
          maxItems.map(value => value),
          nextToken.map(value => value),
          semanticVersion.map(value => value)
        )
    def applicationId: __string
    def maxItems: Optional[MaxItems]
    def nextToken: Optional[__string]
    def semanticVersion: Optional[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getMaxItems: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSemanticVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("semanticVersion", semanticVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest
  ) extends zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesRequest.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val maxItems: Optional[MaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.MaxItems(value)
      )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val semanticVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.semanticVersion())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest
  ): zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesRequest.ReadOnly =
    new Wrapper(impl)
}
