package zio.aws.serverlessapplicationrepository.model
import scala.jdk.CollectionConverters._
sealed trait Capability {
  def unwrap
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.Capability
}
object Capability {
  def wrap(
      value: software.amazon.awssdk.services.serverlessapplicationrepository.model.Capability
  ): zio.aws.serverlessapplicationrepository.model.Capability = value match {
    case software.amazon.awssdk.services.serverlessapplicationrepository.model.Capability.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.serverlessapplicationrepository.model.Capability.CAPABILITY_IAM =>
      val r = CAPABILITY_IAM
      r
    case software.amazon.awssdk.services.serverlessapplicationrepository.model.Capability.CAPABILITY_NAMED_IAM =>
      val r = CAPABILITY_NAMED_IAM
      r
    case software.amazon.awssdk.services.serverlessapplicationrepository.model.Capability.CAPABILITY_AUTO_EXPAND =>
      val r = CAPABILITY_AUTO_EXPAND
      r
    case software.amazon.awssdk.services.serverlessapplicationrepository.model.Capability.CAPABILITY_RESOURCE_POLICY =>
      val r = CAPABILITY_RESOURCE_POLICY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.serverlessapplicationrepository.model.Capability {
    override def unwrap
        : software.amazon.awssdk.services.serverlessapplicationrepository.model.Capability =
      software.amazon.awssdk.services.serverlessapplicationrepository.model.Capability.UNKNOWN_TO_SDK_VERSION
  }
  case object CAPABILITY_IAM
      extends zio.aws.serverlessapplicationrepository.model.Capability {
    override def unwrap
        : software.amazon.awssdk.services.serverlessapplicationrepository.model.Capability =
      software.amazon.awssdk.services.serverlessapplicationrepository.model.Capability.CAPABILITY_IAM
  }
  case object CAPABILITY_NAMED_IAM
      extends zio.aws.serverlessapplicationrepository.model.Capability {
    override def unwrap
        : software.amazon.awssdk.services.serverlessapplicationrepository.model.Capability =
      software.amazon.awssdk.services.serverlessapplicationrepository.model.Capability.CAPABILITY_NAMED_IAM
  }
  case object CAPABILITY_AUTO_EXPAND
      extends zio.aws.serverlessapplicationrepository.model.Capability {
    override def unwrap
        : software.amazon.awssdk.services.serverlessapplicationrepository.model.Capability =
      software.amazon.awssdk.services.serverlessapplicationrepository.model.Capability.CAPABILITY_AUTO_EXPAND
  }
  case object CAPABILITY_RESOURCE_POLICY
      extends zio.aws.serverlessapplicationrepository.model.Capability {
    override def unwrap
        : software.amazon.awssdk.services.serverlessapplicationrepository.model.Capability =
      software.amazon.awssdk.services.serverlessapplicationrepository.model.Capability.CAPABILITY_RESOURCE_POLICY
  }
}
