package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class CreateApplicationRequest(
    author: __string,
    description: __string,
    homePageUrl: Optional[__string] = Optional.Absent,
    labels: Optional[Iterable[__string]] = Optional.Absent,
    licenseBody: Optional[__string] = Optional.Absent,
    licenseUrl: Optional[__string] = Optional.Absent,
    name: __string,
    readmeBody: Optional[__string] = Optional.Absent,
    readmeUrl: Optional[__string] = Optional.Absent,
    semanticVersion: Optional[__string] = Optional.Absent,
    sourceCodeArchiveUrl: Optional[__string] = Optional.Absent,
    sourceCodeUrl: Optional[__string] = Optional.Absent,
    spdxLicenseId: Optional[__string] = Optional.Absent,
    templateBody: Optional[__string] = Optional.Absent,
    templateUrl: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationRequest = {
    import CreateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationRequest
      .builder()
      .author(author: java.lang.String)
      .description(description: java.lang.String)
      .optionallyWith(homePageUrl.map(value => value: java.lang.String))(
        _.homePageUrl
      )
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(licenseBody.map(value => value: java.lang.String))(
        _.licenseBody
      )
      .optionallyWith(licenseUrl.map(value => value: java.lang.String))(
        _.licenseUrl
      )
      .name(name: java.lang.String)
      .optionallyWith(readmeBody.map(value => value: java.lang.String))(
        _.readmeBody
      )
      .optionallyWith(readmeUrl.map(value => value: java.lang.String))(
        _.readmeUrl
      )
      .optionallyWith(semanticVersion.map(value => value: java.lang.String))(
        _.semanticVersion
      )
      .optionallyWith(
        sourceCodeArchiveUrl.map(value => value: java.lang.String)
      )(_.sourceCodeArchiveUrl)
      .optionallyWith(sourceCodeUrl.map(value => value: java.lang.String))(
        _.sourceCodeUrl
      )
      .optionallyWith(spdxLicenseId.map(value => value: java.lang.String))(
        _.spdxLicenseId
      )
      .optionallyWith(templateBody.map(value => value: java.lang.String))(
        _.templateBody
      )
      .optionallyWith(templateUrl.map(value => value: java.lang.String))(
        _.templateUrl
      )
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.CreateApplicationRequest.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.CreateApplicationRequest
      .wrap(buildAwsValue())
}
object CreateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.CreateApplicationRequest =
      zio.aws.serverlessapplicationrepository.model.CreateApplicationRequest(
        author,
        description,
        homePageUrl.map(value => value),
        labels.map(value => value),
        licenseBody.map(value => value),
        licenseUrl.map(value => value),
        name,
        readmeBody.map(value => value),
        readmeUrl.map(value => value),
        semanticVersion.map(value => value),
        sourceCodeArchiveUrl.map(value => value),
        sourceCodeUrl.map(value => value),
        spdxLicenseId.map(value => value),
        templateBody.map(value => value),
        templateUrl.map(value => value)
      )
    def author: __string
    def description: __string
    def homePageUrl: Optional[__string]
    def labels: Optional[List[__string]]
    def licenseBody: Optional[__string]
    def licenseUrl: Optional[__string]
    def name: __string
    def readmeBody: Optional[__string]
    def readmeUrl: Optional[__string]
    def semanticVersion: Optional[__string]
    def sourceCodeArchiveUrl: Optional[__string]
    def sourceCodeUrl: Optional[__string]
    def spdxLicenseId: Optional[__string]
    def templateBody: Optional[__string]
    def templateUrl: Optional[__string]
    def getAuthor: ZIO[Any, Nothing, __string] = ZIO.succeed(author)
    def getDescription: ZIO[Any, Nothing, __string] = ZIO.succeed(description)
    def getHomePageUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("homePageUrl", homePageUrl)
    def getLabels: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("labels", labels)
    def getLicenseBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("licenseBody", licenseBody)
    def getLicenseUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("licenseUrl", licenseUrl)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getReadmeBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("readmeBody", readmeBody)
    def getReadmeUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("readmeUrl", readmeUrl)
    def getSemanticVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("semanticVersion", semanticVersion)
    def getSourceCodeArchiveUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceCodeArchiveUrl", sourceCodeArchiveUrl)
    def getSourceCodeUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceCodeUrl", sourceCodeUrl)
    def getSpdxLicenseId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("spdxLicenseId", spdxLicenseId)
    def getTemplateBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getTemplateUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateUrl", templateUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationRequest
  ) extends zio.aws.serverlessapplicationrepository.model.CreateApplicationRequest.ReadOnly {
    override val author: __string = impl.author(): __string
    override val description: __string = impl.description(): __string
    override val homePageUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.homePageUrl())
      .map(value => value: __string)
    override val labels: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val licenseBody: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseBody())
      .map(value => value: __string)
    override val licenseUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseUrl())
      .map(value => value: __string)
    override val name: __string = impl.name(): __string
    override val readmeBody: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.readmeBody())
      .map(value => value: __string)
    override val readmeUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.readmeUrl())
      .map(value => value: __string)
    override val semanticVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.semanticVersion())
      .map(value => value: __string)
    override val sourceCodeArchiveUrl: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceCodeArchiveUrl())
        .map(value => value: __string)
    override val sourceCodeUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceCodeUrl())
      .map(value => value: __string)
    override val spdxLicenseId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.spdxLicenseId())
      .map(value => value: __string)
    override val templateBody: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateBody())
      .map(value => value: __string)
    override val templateUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateUrl())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationRequest
  ): zio.aws.serverlessapplicationrepository.model.CreateApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
