package zio.aws.serverlessapplicationrepository.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.{
  __boolean,
  __integer,
  __string
}
import scala.jdk.CollectionConverters._
final case class ParameterDefinition(
    allowedPattern: Option[__string] = None,
    allowedValues: Option[Iterable[__string]] = None,
    constraintDescription: Option[__string] = None,
    defaultValue: Option[__string] = None,
    description: Option[__string] = None,
    maxLength: Option[__integer] = None,
    maxValue: Option[__integer] = None,
    minLength: Option[__integer] = None,
    minValue: Option[__integer] = None,
    name: __string,
    noEcho: Option[__boolean] = None,
    referencedByResources: Iterable[__string],
    `type`: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.ParameterDefinition = {
    import ParameterDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ParameterDefinition
      .builder()
      .optionallyWith(allowedPattern.map(value => value: java.lang.String))(
        _.allowedPattern
      )
      .optionallyWith(
        allowedValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.allowedValues)
      .optionallyWith(
        constraintDescription.map(value => value: java.lang.String)
      )(_.constraintDescription)
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(maxLength.map(value => value: Integer))(_.maxLength)
      .optionallyWith(maxValue.map(value => value: Integer))(_.maxValue)
      .optionallyWith(minLength.map(value => value: Integer))(_.minLength)
      .optionallyWith(minValue.map(value => value: Integer))(_.minValue)
      .name(name: java.lang.String)
      .optionallyWith(noEcho.map(value => value: java.lang.Boolean))(_.noEcho)
      .referencedByResources(referencedByResources.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.ParameterDefinition.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.ParameterDefinition
      .wrap(buildAwsValue())
}
object ParameterDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ParameterDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.ParameterDefinition =
      zio.aws.serverlessapplicationrepository.model.ParameterDefinition(
        allowedPattern.map(value => value),
        allowedValues.map(value => value),
        constraintDescription.map(value => value),
        defaultValue.map(value => value),
        description.map(value => value),
        maxLength.map(value => value),
        maxValue.map(value => value),
        minLength.map(value => value),
        minValue.map(value => value),
        name,
        noEcho.map(value => value),
        referencedByResources,
        `type`.map(value => value)
      )
    def allowedPattern: Option[__string]
    def allowedValues: Option[List[__string]]
    def constraintDescription: Option[__string]
    def defaultValue: Option[__string]
    def description: Option[__string]
    def maxLength: Option[__integer]
    def maxValue: Option[__integer]
    def minLength: Option[__integer]
    def minValue: Option[__integer]
    def name: __string
    def noEcho: Option[__boolean]
    def referencedByResources: List[__string]
    def `type`: Option[__string]
    def getAllowedPattern: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("allowedPattern", allowedPattern)
    def getAllowedValues: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getConstraintDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("constraintDescription", constraintDescription)
    def getDefaultValue: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getMaxLength: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxLength", maxLength)
    def getMaxValue: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxValue", maxValue)
    def getMinLength: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("minLength", minLength)
    def getMinValue: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("minValue", minValue)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getNoEcho: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("noEcho", noEcho)
    def getReferencedByResources: ZIO[Any, Nothing, List[__string]] =
      ZIO.succeed(referencedByResources)
    def getType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ParameterDefinition
  ) extends zio.aws.serverlessapplicationrepository.model.ParameterDefinition.ReadOnly {
    override val allowedPattern: Option[__string] =
      scala.Option(impl.allowedPattern()).map(value => value: __string)
    override val allowedValues: Option[List[__string]] = scala
      .Option(impl.allowedValues())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val constraintDescription: Option[__string] =
      scala.Option(impl.constraintDescription()).map(value => value: __string)
    override val defaultValue: Option[__string] =
      scala.Option(impl.defaultValue()).map(value => value: __string)
    override val description: Option[__string] =
      scala.Option(impl.description()).map(value => value: __string)
    override val maxLength: Option[__integer] =
      scala.Option(impl.maxLength()).map(value => value: __integer)
    override val maxValue: Option[__integer] =
      scala.Option(impl.maxValue()).map(value => value: __integer)
    override val minLength: Option[__integer] =
      scala.Option(impl.minLength()).map(value => value: __integer)
    override val minValue: Option[__integer] =
      scala.Option(impl.minValue()).map(value => value: __integer)
    override val name: __string = impl.name(): __string
    override val noEcho: Option[__boolean] =
      scala.Option(impl.noEcho()).map(value => value: __boolean)
    override val referencedByResources: List[__string] = impl
      .referencedByResources()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
    override val `type`: Option[__string] =
      scala.Option(impl.`type`()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ParameterDefinition
  ): zio.aws.serverlessapplicationrepository.model.ParameterDefinition.ReadOnly =
    new Wrapper(impl)
}
