package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class UpdateApplicationRequest(
    applicationId: __string,
    author: Option[__string] = None,
    description: Option[__string] = None,
    homePageUrl: Option[__string] = None,
    labels: Option[Iterable[__string]] = None,
    readmeBody: Option[__string] = None,
    readmeUrl: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.UpdateApplicationRequest = {
    import UpdateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.UpdateApplicationRequest
      .builder()
      .applicationId(applicationId: java.lang.String)
      .optionallyWith(author.map(value => value: java.lang.String))(_.author)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(homePageUrl.map(value => value: java.lang.String))(
        _.homePageUrl
      )
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(readmeBody.map(value => value: java.lang.String))(
        _.readmeBody
      )
      .optionallyWith(readmeUrl.map(value => value: java.lang.String))(
        _.readmeUrl
      )
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.UpdateApplicationRequest.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.UpdateApplicationRequest
      .wrap(buildAwsValue())
}
object UpdateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.UpdateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.UpdateApplicationRequest =
      zio.aws.serverlessapplicationrepository.model.UpdateApplicationRequest(
        applicationId,
        author.map(value => value),
        description.map(value => value),
        homePageUrl.map(value => value),
        labels.map(value => value),
        readmeBody.map(value => value),
        readmeUrl.map(value => value)
      )
    def applicationId: __string
    def author: Option[__string]
    def description: Option[__string]
    def homePageUrl: Option[__string]
    def labels: Option[List[__string]]
    def readmeBody: Option[__string]
    def readmeUrl: Option[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getAuthor: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("author", author)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getHomePageUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("homePageUrl", homePageUrl)
    def getLabels: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("labels", labels)
    def getReadmeBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("readmeBody", readmeBody)
    def getReadmeUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("readmeUrl", readmeUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.UpdateApplicationRequest
  ) extends zio.aws.serverlessapplicationrepository.model.UpdateApplicationRequest.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val author: Option[__string] =
      scala.Option(impl.author()).map(value => value: __string)
    override val description: Option[__string] =
      scala.Option(impl.description()).map(value => value: __string)
    override val homePageUrl: Option[__string] =
      scala.Option(impl.homePageUrl()).map(value => value: __string)
    override val labels: Option[List[__string]] = scala
      .Option(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val readmeBody: Option[__string] =
      scala.Option(impl.readmeBody()).map(value => value: __string)
    override val readmeUrl: Option[__string] =
      scala.Option(impl.readmeUrl()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.UpdateApplicationRequest
  ): zio.aws.serverlessapplicationrepository.model.UpdateApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
