package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait VulnerabilityExploitAvailable {
  def unwrap: software.amazon.awssdk.services.securityhub.model.VulnerabilityExploitAvailable
}
object VulnerabilityExploitAvailable {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.VulnerabilityExploitAvailable
  ): zio.aws.securityhub.model.VulnerabilityExploitAvailable = value match {
    case software.amazon.awssdk.services.securityhub.model.VulnerabilityExploitAvailable.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.VulnerabilityExploitAvailable.YES =>
      val r = YES
      r
    case software.amazon.awssdk.services.securityhub.model.VulnerabilityExploitAvailable.NO =>
      val r = NO
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.VulnerabilityExploitAvailable {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.VulnerabilityExploitAvailable =
      software.amazon.awssdk.services.securityhub.model.VulnerabilityExploitAvailable.UNKNOWN_TO_SDK_VERSION
  }
  case object YES
      extends zio.aws.securityhub.model.VulnerabilityExploitAvailable {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.VulnerabilityExploitAvailable =
      software.amazon.awssdk.services.securityhub.model.VulnerabilityExploitAvailable.YES
  }
  case object NO
      extends zio.aws.securityhub.model.VulnerabilityExploitAvailable {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.VulnerabilityExploitAvailable =
      software.amazon.awssdk.services.securityhub.model.VulnerabilityExploitAvailable.NO
  }
}
