package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VulnerabilityCodeVulnerabilities(
    cwes: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    filePath: Optional[zio.aws.securityhub.model.CodeVulnerabilitiesFilePath] =
      Optional.Absent,
    sourceArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.VulnerabilityCodeVulnerabilities = {
    import VulnerabilityCodeVulnerabilities.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.VulnerabilityCodeVulnerabilities
      .builder()
      .optionallyWith(
        cwes.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.cwes)
      .optionallyWith(filePath.map(value => value.buildAwsValue()))(_.filePath)
      .optionallyWith(
        sourceArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sourceArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.VulnerabilityCodeVulnerabilities.ReadOnly =
    zio.aws.securityhub.model.VulnerabilityCodeVulnerabilities
      .wrap(buildAwsValue())
}
object VulnerabilityCodeVulnerabilities {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.VulnerabilityCodeVulnerabilities
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.VulnerabilityCodeVulnerabilities =
      zio.aws.securityhub.model.VulnerabilityCodeVulnerabilities(
        cwes.map(value => value),
        filePath.map(value => value.asEditable),
        sourceArn.map(value => value)
      )
    def cwes: Optional[List[NonEmptyString]]
    def filePath: Optional[
      zio.aws.securityhub.model.CodeVulnerabilitiesFilePath.ReadOnly
    ]
    def sourceArn: Optional[NonEmptyString]
    def getCwes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("cwes", cwes)
    def getFilePath: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.CodeVulnerabilitiesFilePath.ReadOnly
    ] = AwsError.unwrapOptionField("filePath", filePath)
    def getSourceArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.VulnerabilityCodeVulnerabilities
  ) extends zio.aws.securityhub.model.VulnerabilityCodeVulnerabilities.ReadOnly {
    override val cwes: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.cwes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val filePath: Optional[
      zio.aws.securityhub.model.CodeVulnerabilitiesFilePath.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filePath())
      .map(value =>
        zio.aws.securityhub.model.CodeVulnerabilitiesFilePath.wrap(value)
      )
    override val sourceArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.VulnerabilityCodeVulnerabilities
  ): zio.aws.securityhub.model.VulnerabilityCodeVulnerabilities.ReadOnly =
    new Wrapper(impl)
}
