package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcInfoCidrBlockSetDetails(
    cidrBlock: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.VpcInfoCidrBlockSetDetails = {
    import VpcInfoCidrBlockSetDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.VpcInfoCidrBlockSetDetails
      .builder()
      .optionallyWith(
        cidrBlock.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cidrBlock)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.VpcInfoCidrBlockSetDetails.ReadOnly =
    zio.aws.securityhub.model.VpcInfoCidrBlockSetDetails.wrap(buildAwsValue())
}
object VpcInfoCidrBlockSetDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.VpcInfoCidrBlockSetDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.VpcInfoCidrBlockSetDetails =
      zio.aws.securityhub.model
        .VpcInfoCidrBlockSetDetails(cidrBlock.map(value => value))
    def cidrBlock: Optional[NonEmptyString]
    def getCidrBlock: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.VpcInfoCidrBlockSetDetails
  ) extends zio.aws.securityhub.model.VpcInfoCidrBlockSetDetails.ReadOnly {
    override val cidrBlock: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrBlock())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.VpcInfoCidrBlockSetDetails
  ): zio.aws.securityhub.model.VpcInfoCidrBlockSetDetails.ReadOnly =
    new Wrapper(impl)
}
