package zio.aws.securityhub.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{Timestamp, NonEmptyString}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class StandardsControlAssociationDetail(
    standardsArn: NonEmptyString,
    securityControlId: NonEmptyString,
    securityControlArn: NonEmptyString,
    associationStatus: zio.aws.securityhub.model.AssociationStatus,
    relatedRequirements: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    updatedReason: Optional[NonEmptyString] = Optional.Absent,
    standardsControlTitle: Optional[NonEmptyString] = Optional.Absent,
    standardsControlDescription: Optional[NonEmptyString] = Optional.Absent,
    standardsControlArns: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationDetail = {
    import StandardsControlAssociationDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationDetail
      .builder()
      .standardsArn(NonEmptyString.unwrap(standardsArn): java.lang.String)
      .securityControlId(
        NonEmptyString.unwrap(securityControlId): java.lang.String
      )
      .securityControlArn(
        NonEmptyString.unwrap(securityControlArn): java.lang.String
      )
      .associationStatus(associationStatus.unwrap)
      .optionallyWith(
        relatedRequirements.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.relatedRequirements)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedReason.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.updatedReason)
      .optionallyWith(
        standardsControlTitle.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.standardsControlTitle)
      .optionallyWith(
        standardsControlDescription.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.standardsControlDescription)
      .optionallyWith(
        standardsControlArns.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.standardsControlArns)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.StandardsControlAssociationDetail.ReadOnly =
    zio.aws.securityhub.model.StandardsControlAssociationDetail
      .wrap(buildAwsValue())
}
object StandardsControlAssociationDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.StandardsControlAssociationDetail =
      zio.aws.securityhub.model.StandardsControlAssociationDetail(
        standardsArn,
        securityControlId,
        securityControlArn,
        associationStatus,
        relatedRequirements.map(value => value),
        updatedAt.map(value => value),
        updatedReason.map(value => value),
        standardsControlTitle.map(value => value),
        standardsControlDescription.map(value => value),
        standardsControlArns.map(value => value)
      )
    def standardsArn: NonEmptyString
    def securityControlId: NonEmptyString
    def securityControlArn: NonEmptyString
    def associationStatus: zio.aws.securityhub.model.AssociationStatus
    def relatedRequirements: Optional[List[NonEmptyString]]
    def updatedAt: Optional[Timestamp]
    def updatedReason: Optional[NonEmptyString]
    def standardsControlTitle: Optional[NonEmptyString]
    def standardsControlDescription: Optional[NonEmptyString]
    def standardsControlArns: Optional[List[NonEmptyString]]
    def getStandardsArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(standardsArn)
    def getSecurityControlId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(securityControlId)
    def getSecurityControlArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(securityControlArn)
    def getAssociationStatus
        : ZIO[Any, Nothing, zio.aws.securityhub.model.AssociationStatus] =
      ZIO.succeed(associationStatus)
    def getRelatedRequirements: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("relatedRequirements", relatedRequirements)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("updatedReason", updatedReason)
    def getStandardsControlTitle: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("standardsControlTitle", standardsControlTitle)
    def getStandardsControlDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "standardsControlDescription",
        standardsControlDescription
      )
    def getStandardsControlArns: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("standardsControlArns", standardsControlArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationDetail
  ) extends zio.aws.securityhub.model.StandardsControlAssociationDetail.ReadOnly {
    override val standardsArn: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.standardsArn())
    override val securityControlId: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.securityControlId())
    override val securityControlArn: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.securityControlArn())
    override val associationStatus
        : zio.aws.securityhub.model.AssociationStatus =
      zio.aws.securityhub.model.AssociationStatus.wrap(impl.associationStatus())
    override val relatedRequirements: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedRequirements())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.securityhub.model.primitives.Timestamp(value))
    override val updatedReason: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedReason())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val standardsControlTitle: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.standardsControlTitle())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val standardsControlDescription: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.standardsControlDescription())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val standardsControlArns: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.standardsControlArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationDetail
  ): zio.aws.securityhub.model.StandardsControlAssociationDetail.ReadOnly =
    new Wrapper(impl)
}
