package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStandardsControlAssociationsResponse(
    standardsControlAssociationSummaries: Iterable[
      zio.aws.securityhub.model.StandardsControlAssociationSummary
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsResponse = {
    import ListStandardsControlAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsResponse
      .builder()
      .standardsControlAssociationSummaries(
        standardsControlAssociationSummaries.map { item =>
          item.buildAwsValue()
        }.asJavaCollection
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.ListStandardsControlAssociationsResponse.ReadOnly =
    zio.aws.securityhub.model.ListStandardsControlAssociationsResponse
      .wrap(buildAwsValue())
}
object ListStandardsControlAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.ListStandardsControlAssociationsResponse =
      zio.aws.securityhub.model.ListStandardsControlAssociationsResponse(
        standardsControlAssociationSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def standardsControlAssociationSummaries: List[
      zio.aws.securityhub.model.StandardsControlAssociationSummary.ReadOnly
    ]
    def nextToken: Optional[NextToken]
    def getStandardsControlAssociationSummaries: ZIO[Any, Nothing, List[
      zio.aws.securityhub.model.StandardsControlAssociationSummary.ReadOnly
    ]] = ZIO.succeed(standardsControlAssociationSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsResponse
  ) extends zio.aws.securityhub.model.ListStandardsControlAssociationsResponse.ReadOnly {
    override val standardsControlAssociationSummaries: List[
      zio.aws.securityhub.model.StandardsControlAssociationSummary.ReadOnly
    ] = impl
      .standardsControlAssociationSummaries()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.StandardsControlAssociationSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsResponse
  ): zio.aws.securityhub.model.ListStandardsControlAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
