package zio.aws.securityhub.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{NextToken, AdminsMaxResults}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListOrganizationAdminAccountsRequest(
    maxResults: Optional[AdminsMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest = {
    import ListOrganizationAdminAccountsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => AdminsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.ListOrganizationAdminAccountsRequest.ReadOnly =
    zio.aws.securityhub.model.ListOrganizationAdminAccountsRequest
      .wrap(buildAwsValue())
}
object ListOrganizationAdminAccountsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.ListOrganizationAdminAccountsRequest =
      zio.aws.securityhub.model.ListOrganizationAdminAccountsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[AdminsMaxResults]
    def nextToken: Optional[NextToken]
    def getMaxResults: ZIO[Any, AwsError, AdminsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest
  ) extends zio.aws.securityhub.model.ListOrganizationAdminAccountsRequest.ReadOnly {
    override val maxResults: Optional[AdminsMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.securityhub.model.primitives.AdminsMaxResults(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest
  ): zio.aws.securityhub.model.ListOrganizationAdminAccountsRequest.ReadOnly =
    new Wrapper(impl)
}
