package zio.aws.securityhub.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{MaxResults, NextToken, Timestamp}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetFindingHistoryRequest(
    findingIdentifier: zio.aws.securityhub.model.AwsSecurityFindingIdentifier,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.GetFindingHistoryRequest = {
    import GetFindingHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.GetFindingHistoryRequest
      .builder()
      .findingIdentifier(findingIdentifier.buildAwsValue())
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.GetFindingHistoryRequest.ReadOnly =
    zio.aws.securityhub.model.GetFindingHistoryRequest.wrap(buildAwsValue())
}
object GetFindingHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.GetFindingHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.GetFindingHistoryRequest =
      zio.aws.securityhub.model.GetFindingHistoryRequest(
        findingIdentifier.asEditable,
        startTime.map(value => value),
        endTime.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def findingIdentifier
        : zio.aws.securityhub.model.AwsSecurityFindingIdentifier.ReadOnly
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getFindingIdentifier: ZIO[
      Any,
      Nothing,
      zio.aws.securityhub.model.AwsSecurityFindingIdentifier.ReadOnly
    ] = ZIO.succeed(findingIdentifier)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.GetFindingHistoryRequest
  ) extends zio.aws.securityhub.model.GetFindingHistoryRequest.ReadOnly {
    override val findingIdentifier
        : zio.aws.securityhub.model.AwsSecurityFindingIdentifier.ReadOnly =
      zio.aws.securityhub.model.AwsSecurityFindingIdentifier
        .wrap(impl.findingIdentifier())
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.securityhub.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.securityhub.model.primitives.Timestamp(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.securityhub.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.GetFindingHistoryRequest
  ): zio.aws.securityhub.model.GetFindingHistoryRequest.ReadOnly = new Wrapper(
    impl
  )
}
