package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FilePaths(
    filePath: Optional[NonEmptyString] = Optional.Absent,
    fileName: Optional[NonEmptyString] = Optional.Absent,
    resourceId: Optional[NonEmptyString] = Optional.Absent,
    hash: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.FilePaths = {
    import FilePaths.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.FilePaths
      .builder()
      .optionallyWith(
        filePath.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.filePath)
      .optionallyWith(
        fileName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.fileName)
      .optionallyWith(
        resourceId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        hash.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.hash)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.FilePaths.ReadOnly =
    zio.aws.securityhub.model.FilePaths.wrap(buildAwsValue())
}
object FilePaths {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.FilePaths
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.FilePaths =
      zio.aws.securityhub.model.FilePaths(
        filePath.map(value => value),
        fileName.map(value => value),
        resourceId.map(value => value),
        hash.map(value => value)
      )
    def filePath: Optional[NonEmptyString]
    def fileName: Optional[NonEmptyString]
    def resourceId: Optional[NonEmptyString]
    def hash: Optional[NonEmptyString]
    def getFilePath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("filePath", filePath)
    def getFileName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fileName", fileName)
    def getResourceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getHash: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hash", hash)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.FilePaths
  ) extends zio.aws.securityhub.model.FilePaths.ReadOnly {
    override val filePath: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.filePath())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val fileName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.fileName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val resourceId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val hash: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.hash())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.FilePaths
  ): zio.aws.securityhub.model.FilePaths.ReadOnly = new Wrapper(impl)
}
