package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateMembersRequest(
    accountIds: Iterable[NonEmptyString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DisassociateMembersRequest = {
    import DisassociateMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DisassociateMembersRequest
      .builder()
      .accountIds(accountIds.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.DisassociateMembersRequest.ReadOnly =
    zio.aws.securityhub.model.DisassociateMembersRequest.wrap(buildAwsValue())
}
object DisassociateMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DisassociateMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DisassociateMembersRequest =
      zio.aws.securityhub.model.DisassociateMembersRequest(accountIds)
    def accountIds: List[NonEmptyString]
    def getAccountIds: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DisassociateMembersRequest
  ) extends zio.aws.securityhub.model.DisassociateMembersRequest.ReadOnly {
    override val accountIds: List[NonEmptyString] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DisassociateMembersRequest
  ): zio.aws.securityhub.model.DisassociateMembersRequest.ReadOnly =
    new Wrapper(impl)
}
