package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContainerDetails(
    containerRuntime: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    imageId: Optional[NonEmptyString] = Optional.Absent,
    imageName: Optional[NonEmptyString] = Optional.Absent,
    launchedAt: Optional[NonEmptyString] = Optional.Absent,
    volumeMounts: Optional[Iterable[zio.aws.securityhub.model.VolumeMount]] =
      Optional.Absent,
    privileged: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ContainerDetails = {
    import ContainerDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ContainerDetails
      .builder()
      .optionallyWith(
        containerRuntime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.containerRuntime)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        imageId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(
        imageName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.imageName)
      .optionallyWith(
        launchedAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.launchedAt)
      .optionallyWith(
        volumeMounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumeMounts)
      .optionallyWith(privileged.map(value => value: java.lang.Boolean))(
        _.privileged
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ContainerDetails.ReadOnly =
    zio.aws.securityhub.model.ContainerDetails.wrap(buildAwsValue())
}
object ContainerDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ContainerDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ContainerDetails =
      zio.aws.securityhub.model.ContainerDetails(
        containerRuntime.map(value => value),
        name.map(value => value),
        imageId.map(value => value),
        imageName.map(value => value),
        launchedAt.map(value => value),
        volumeMounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        privileged.map(value => value)
      )
    def containerRuntime: Optional[NonEmptyString]
    def name: Optional[NonEmptyString]
    def imageId: Optional[NonEmptyString]
    def imageName: Optional[NonEmptyString]
    def launchedAt: Optional[NonEmptyString]
    def volumeMounts
        : Optional[List[zio.aws.securityhub.model.VolumeMount.ReadOnly]]
    def privileged: Optional[Boolean]
    def getContainerRuntime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("containerRuntime", containerRuntime)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getImageId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getImageName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("imageName", imageName)
    def getLaunchedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("launchedAt", launchedAt)
    def getVolumeMounts: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.VolumeMount.ReadOnly
    ]] = AwsError.unwrapOptionField("volumeMounts", volumeMounts)
    def getPrivileged: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("privileged", privileged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ContainerDetails
  ) extends zio.aws.securityhub.model.ContainerDetails.ReadOnly {
    override val containerRuntime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerRuntime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val imageId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val imageName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.imageName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val launchedAt: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.launchedAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val volumeMounts
        : Optional[List[zio.aws.securityhub.model.VolumeMount.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeMounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.VolumeMount.wrap(item)
          }.toList
        )
    override val privileged: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.privileged())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ContainerDetails
  ): zio.aws.securityhub.model.ContainerDetails.ReadOnly = new Wrapper(impl)
}
