package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CodeVulnerabilitiesFilePath(
    endLine: Optional[Integer] = Optional.Absent,
    fileName: Optional[NonEmptyString] = Optional.Absent,
    filePath: Optional[NonEmptyString] = Optional.Absent,
    startLine: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.CodeVulnerabilitiesFilePath = {
    import CodeVulnerabilitiesFilePath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.CodeVulnerabilitiesFilePath
      .builder()
      .optionallyWith(endLine.map(value => value: java.lang.Integer))(_.endLine)
      .optionallyWith(
        fileName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.fileName)
      .optionallyWith(
        filePath.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.filePath)
      .optionallyWith(startLine.map(value => value: java.lang.Integer))(
        _.startLine
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.CodeVulnerabilitiesFilePath.ReadOnly =
    zio.aws.securityhub.model.CodeVulnerabilitiesFilePath.wrap(buildAwsValue())
}
object CodeVulnerabilitiesFilePath {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.CodeVulnerabilitiesFilePath
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.CodeVulnerabilitiesFilePath =
      zio.aws.securityhub.model.CodeVulnerabilitiesFilePath(
        endLine.map(value => value),
        fileName.map(value => value),
        filePath.map(value => value),
        startLine.map(value => value)
      )
    def endLine: Optional[Integer]
    def fileName: Optional[NonEmptyString]
    def filePath: Optional[NonEmptyString]
    def startLine: Optional[Integer]
    def getEndLine: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("endLine", endLine)
    def getFileName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fileName", fileName)
    def getFilePath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("filePath", filePath)
    def getStartLine: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("startLine", startLine)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.CodeVulnerabilitiesFilePath
  ) extends zio.aws.securityhub.model.CodeVulnerabilitiesFilePath.ReadOnly {
    override val endLine: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.endLine())
      .map(value => value: Integer)
    override val fileName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.fileName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val filePath: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.filePath())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val startLine: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.startLine())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.CodeVulnerabilitiesFilePath
  ): zio.aws.securityhub.model.CodeVulnerabilitiesFilePath.ReadOnly =
    new Wrapper(impl)
}
