package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CloudWatchLogsLogGroupArnConfigDetails(
    cloudWatchLogsLogGroupArn: Optional[NonEmptyString] = Optional.Absent,
    hostedZoneId: Optional[NonEmptyString] = Optional.Absent,
    id: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.CloudWatchLogsLogGroupArnConfigDetails = {
    import CloudWatchLogsLogGroupArnConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.CloudWatchLogsLogGroupArnConfigDetails
      .builder()
      .optionallyWith(
        cloudWatchLogsLogGroupArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogsLogGroupArn)
      .optionallyWith(
        hostedZoneId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.hostedZoneId)
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.CloudWatchLogsLogGroupArnConfigDetails.ReadOnly =
    zio.aws.securityhub.model.CloudWatchLogsLogGroupArnConfigDetails
      .wrap(buildAwsValue())
}
object CloudWatchLogsLogGroupArnConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.CloudWatchLogsLogGroupArnConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.CloudWatchLogsLogGroupArnConfigDetails =
      zio.aws.securityhub.model.CloudWatchLogsLogGroupArnConfigDetails(
        cloudWatchLogsLogGroupArn.map(value => value),
        hostedZoneId.map(value => value),
        id.map(value => value)
      )
    def cloudWatchLogsLogGroupArn: Optional[NonEmptyString]
    def hostedZoneId: Optional[NonEmptyString]
    def id: Optional[NonEmptyString]
    def getCloudWatchLogsLogGroupArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "cloudWatchLogsLogGroupArn",
        cloudWatchLogsLogGroupArn
      )
    def getHostedZoneId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.CloudWatchLogsLogGroupArnConfigDetails
  ) extends zio.aws.securityhub.model.CloudWatchLogsLogGroupArnConfigDetails.ReadOnly {
    override val cloudWatchLogsLogGroupArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogsLogGroupArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val hostedZoneId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.hostedZoneId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.CloudWatchLogsLogGroupArnConfigDetails
  ): zio.aws.securityhub.model.CloudWatchLogsLogGroupArnConfigDetails.ReadOnly =
    new Wrapper(impl)
}
