package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetStandardsControlAssociationsRequest(
    standardsControlAssociationIds: Iterable[
      zio.aws.securityhub.model.StandardsControlAssociationId
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchGetStandardsControlAssociationsRequest = {
    import BatchGetStandardsControlAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchGetStandardsControlAssociationsRequest
      .builder()
      .standardsControlAssociationIds(standardsControlAssociationIds.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchGetStandardsControlAssociationsRequest.ReadOnly =
    zio.aws.securityhub.model.BatchGetStandardsControlAssociationsRequest
      .wrap(buildAwsValue())
}
object BatchGetStandardsControlAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchGetStandardsControlAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.BatchGetStandardsControlAssociationsRequest =
      zio.aws.securityhub.model.BatchGetStandardsControlAssociationsRequest(
        standardsControlAssociationIds.map { item =>
          item.asEditable
        }
      )
    def standardsControlAssociationIds
        : List[zio.aws.securityhub.model.StandardsControlAssociationId.ReadOnly]
    def getStandardsControlAssociationIds: ZIO[Any, Nothing, List[
      zio.aws.securityhub.model.StandardsControlAssociationId.ReadOnly
    ]] = ZIO.succeed(standardsControlAssociationIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchGetStandardsControlAssociationsRequest
  ) extends zio.aws.securityhub.model.BatchGetStandardsControlAssociationsRequest.ReadOnly {
    override val standardsControlAssociationIds: List[
      zio.aws.securityhub.model.StandardsControlAssociationId.ReadOnly
    ] = impl
      .standardsControlAssociationIds()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.StandardsControlAssociationId.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchGetStandardsControlAssociationsRequest
  ): zio.aws.securityhub.model.BatchGetStandardsControlAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
