package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDeleteAutomationRulesRequest(
    automationRulesArns: Iterable[NonEmptyString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchDeleteAutomationRulesRequest = {
    import BatchDeleteAutomationRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchDeleteAutomationRulesRequest
      .builder()
      .automationRulesArns(automationRulesArns.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchDeleteAutomationRulesRequest.ReadOnly =
    zio.aws.securityhub.model.BatchDeleteAutomationRulesRequest
      .wrap(buildAwsValue())
}
object BatchDeleteAutomationRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchDeleteAutomationRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.BatchDeleteAutomationRulesRequest =
      zio.aws.securityhub.model
        .BatchDeleteAutomationRulesRequest(automationRulesArns)
    def automationRulesArns: List[NonEmptyString]
    def getAutomationRulesArns: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(automationRulesArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchDeleteAutomationRulesRequest
  ) extends zio.aws.securityhub.model.BatchDeleteAutomationRulesRequest.ReadOnly {
    override val automationRulesArns: List[NonEmptyString] = impl
      .automationRulesArns()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchDeleteAutomationRulesRequest
  ): zio.aws.securityhub.model.BatchDeleteAutomationRulesRequest.ReadOnly =
    new Wrapper(impl)
}
