package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafv2WebAclCaptchaConfigDetails(
    immunityTimeProperty: Optional[
      zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails = {
    import AwsWafv2WebAclCaptchaConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails
      .builder()
      .optionallyWith(immunityTimeProperty.map(value => value.buildAwsValue()))(
        _.immunityTimeProperty
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails
      .wrap(buildAwsValue())
}
object AwsWafv2WebAclCaptchaConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails =
      zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails(
        immunityTimeProperty.map(value => value.asEditable)
      )
    def immunityTimeProperty: Optional[
      zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails.ReadOnly
    ]
    def getImmunityTimeProperty: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails.ReadOnly
    ] = AwsError.unwrapOptionField("immunityTimeProperty", immunityTimeProperty)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails
  ) extends zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails.ReadOnly {
    override val immunityTimeProperty: Optional[
      zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.immunityTimeProperty())
      .map(value =>
        zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails
  ): zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails.ReadOnly =
    new Wrapper(impl)
}
