package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafv2VisibilityConfigDetails(
    cloudWatchMetricsEnabled: Optional[Boolean] = Optional.Absent,
    metricName: Optional[NonEmptyString] = Optional.Absent,
    sampledRequestsEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafv2VisibilityConfigDetails = {
    import AwsWafv2VisibilityConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafv2VisibilityConfigDetails
      .builder()
      .optionallyWith(
        cloudWatchMetricsEnabled.map(value => value: java.lang.Boolean)
      )(_.cloudWatchMetricsEnabled)
      .optionallyWith(
        metricName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        sampledRequestsEnabled.map(value => value: java.lang.Boolean)
      )(_.sampledRequestsEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails
      .wrap(buildAwsValue())
}
object AwsWafv2VisibilityConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafv2VisibilityConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails =
      zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails(
        cloudWatchMetricsEnabled.map(value => value),
        metricName.map(value => value),
        sampledRequestsEnabled.map(value => value)
      )
    def cloudWatchMetricsEnabled: Optional[Boolean]
    def metricName: Optional[NonEmptyString]
    def sampledRequestsEnabled: Optional[Boolean]
    def getCloudWatchMetricsEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("cloudWatchMetricsEnabled", cloudWatchMetricsEnabled)
    def getMetricName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getSampledRequestsEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("sampledRequestsEnabled", sampledRequestsEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2VisibilityConfigDetails
  ) extends zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails.ReadOnly {
    override val cloudWatchMetricsEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchMetricsEnabled())
        .map(value => value: Boolean)
    override val metricName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sampledRequestsEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sampledRequestsEnabled())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2VisibilityConfigDetails
  ): zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails.ReadOnly =
    new Wrapper(impl)
}
