package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketBucketVersioningConfiguration(
    isMfaDeleteEnabled: Optional[Boolean] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketVersioningConfiguration = {
    import AwsS3BucketBucketVersioningConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketVersioningConfiguration
      .builder()
      .optionallyWith(
        isMfaDeleteEnabled.map(value => value: java.lang.Boolean)
      )(_.isMfaDeleteEnabled)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketBucketVersioningConfiguration.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketBucketVersioningConfiguration
      .wrap(buildAwsValue())
}
object AwsS3BucketBucketVersioningConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketVersioningConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketBucketVersioningConfiguration =
      zio.aws.securityhub.model.AwsS3BucketBucketVersioningConfiguration(
        isMfaDeleteEnabled.map(value => value),
        status.map(value => value)
      )
    def isMfaDeleteEnabled: Optional[Boolean]
    def status: Optional[NonEmptyString]
    def getIsMfaDeleteEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isMfaDeleteEnabled", isMfaDeleteEnabled)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketVersioningConfiguration
  ) extends zio.aws.securityhub.model.AwsS3BucketBucketVersioningConfiguration.ReadOnly {
    override val isMfaDeleteEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isMfaDeleteEnabled())
      .map(value => value: Boolean)
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketVersioningConfiguration
  ): zio.aws.securityhub.model.AwsS3BucketBucketVersioningConfiguration.ReadOnly =
    new Wrapper(impl)
}
