package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRoute53HostedZoneObjectDetails(
    id: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    config: Optional[
      zio.aws.securityhub.model.AwsRoute53HostedZoneConfigDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneObjectDetails = {
    import AwsRoute53HostedZoneObjectDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneObjectDetails
      .builder()
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(config.map(value => value.buildAwsValue()))(_.config)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRoute53HostedZoneObjectDetails.ReadOnly =
    zio.aws.securityhub.model.AwsRoute53HostedZoneObjectDetails
      .wrap(buildAwsValue())
}
object AwsRoute53HostedZoneObjectDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneObjectDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsRoute53HostedZoneObjectDetails =
      zio.aws.securityhub.model.AwsRoute53HostedZoneObjectDetails(
        id.map(value => value),
        name.map(value => value),
        config.map(value => value.asEditable)
      )
    def id: Optional[NonEmptyString]
    def name: Optional[NonEmptyString]
    def config: Optional[
      zio.aws.securityhub.model.AwsRoute53HostedZoneConfigDetails.ReadOnly
    ]
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRoute53HostedZoneConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("config", config)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneObjectDetails
  ) extends zio.aws.securityhub.model.AwsRoute53HostedZoneObjectDetails.ReadOnly {
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val config: Optional[
      zio.aws.securityhub.model.AwsRoute53HostedZoneConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.config())
      .map(value =>
        zio.aws.securityhub.model.AwsRoute53HostedZoneConfigDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneObjectDetails
  ): zio.aws.securityhub.model.AwsRoute53HostedZoneObjectDetails.ReadOnly =
    new Wrapper(impl)
}
