package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterVpcSecurityGroup(
    status: Optional[NonEmptyString] = Optional.Absent,
    vpcSecurityGroupId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterVpcSecurityGroup = {
    import AwsRedshiftClusterVpcSecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterVpcSecurityGroup
      .builder()
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        vpcSecurityGroupId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.vpcSecurityGroupId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup
      .wrap(buildAwsValue())
}
object AwsRedshiftClusterVpcSecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterVpcSecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup =
      zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup(
        status.map(value => value),
        vpcSecurityGroupId.map(value => value)
      )
    def status: Optional[NonEmptyString]
    def vpcSecurityGroupId: Optional[NonEmptyString]
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getVpcSecurityGroupId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcSecurityGroupId", vpcSecurityGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterVpcSecurityGroup
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup.ReadOnly {
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcSecurityGroupId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterVpcSecurityGroup
  ): zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup.ReadOnly =
    new Wrapper(impl)
}
