package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRdsPendingCloudWatchLogsExports(
    logTypesToEnable: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    logTypesToDisable: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsPendingCloudWatchLogsExports = {
    import AwsRdsPendingCloudWatchLogsExports.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsPendingCloudWatchLogsExports
      .builder()
      .optionallyWith(
        logTypesToEnable.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.logTypesToEnable)
      .optionallyWith(
        logTypesToDisable.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.logTypesToDisable)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRdsPendingCloudWatchLogsExports.ReadOnly =
    zio.aws.securityhub.model.AwsRdsPendingCloudWatchLogsExports
      .wrap(buildAwsValue())
}
object AwsRdsPendingCloudWatchLogsExports {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsPendingCloudWatchLogsExports
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsRdsPendingCloudWatchLogsExports =
      zio.aws.securityhub.model.AwsRdsPendingCloudWatchLogsExports(
        logTypesToEnable.map(value => value),
        logTypesToDisable.map(value => value)
      )
    def logTypesToEnable: Optional[List[NonEmptyString]]
    def logTypesToDisable: Optional[List[NonEmptyString]]
    def getLogTypesToEnable: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("logTypesToEnable", logTypesToEnable)
    def getLogTypesToDisable: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("logTypesToDisable", logTypesToDisable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsPendingCloudWatchLogsExports
  ) extends zio.aws.securityhub.model.AwsRdsPendingCloudWatchLogsExports.ReadOnly {
    override val logTypesToEnable: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logTypesToEnable())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val logTypesToDisable: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logTypesToDisable())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsPendingCloudWatchLogsExports
  ): zio.aws.securityhub.model.AwsRdsPendingCloudWatchLogsExports.ReadOnly =
    new Wrapper(impl)
}
