package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{
  NonEmptyString,
  AwsLambdaLayerVersionNumber
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsLambdaLayerVersionDetails(
    version: Optional[AwsLambdaLayerVersionNumber] = Optional.Absent,
    compatibleRuntimes: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    createdDate: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsLambdaLayerVersionDetails = {
    import AwsLambdaLayerVersionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsLambdaLayerVersionDetails
      .builder()
      .optionallyWith(
        version.map(value =>
          AwsLambdaLayerVersionNumber.unwrap(value): java.lang.Long
        )
      )(_.version)
      .optionallyWith(
        compatibleRuntimes.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.compatibleRuntimes)
      .optionallyWith(
        createdDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdDate)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsLambdaLayerVersionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsLambdaLayerVersionDetails.wrap(buildAwsValue())
}
object AwsLambdaLayerVersionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsLambdaLayerVersionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsLambdaLayerVersionDetails =
      zio.aws.securityhub.model.AwsLambdaLayerVersionDetails(
        version.map(value => value),
        compatibleRuntimes.map(value => value),
        createdDate.map(value => value)
      )
    def version: Optional[AwsLambdaLayerVersionNumber]
    def compatibleRuntimes: Optional[List[NonEmptyString]]
    def createdDate: Optional[NonEmptyString]
    def getVersion: ZIO[Any, AwsError, AwsLambdaLayerVersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getCompatibleRuntimes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("compatibleRuntimes", compatibleRuntimes)
    def getCreatedDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdDate", createdDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaLayerVersionDetails
  ) extends zio.aws.securityhub.model.AwsLambdaLayerVersionDetails.ReadOnly {
    override val version: Optional[AwsLambdaLayerVersionNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.version())
        .map(value =>
          zio.aws.securityhub.model.primitives
            .AwsLambdaLayerVersionNumber(value)
        )
    override val compatibleRuntimes: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compatibleRuntimes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val createdDate: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaLayerVersionDetails
  ): zio.aws.securityhub.model.AwsLambdaLayerVersionDetails.ReadOnly =
    new Wrapper(impl)
}
