package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsIamUserDetails(
    attachedManagedPolicies: Optional[
      Iterable[zio.aws.securityhub.model.AwsIamAttachedManagedPolicy]
    ] = Optional.Absent,
    createDate: Optional[NonEmptyString] = Optional.Absent,
    groupList: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    path: Optional[NonEmptyString] = Optional.Absent,
    permissionsBoundary: Optional[
      zio.aws.securityhub.model.AwsIamPermissionsBoundary
    ] = Optional.Absent,
    userId: Optional[NonEmptyString] = Optional.Absent,
    userName: Optional[NonEmptyString] = Optional.Absent,
    userPolicyList: Optional[
      Iterable[zio.aws.securityhub.model.AwsIamUserPolicy]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamUserDetails = {
    import AwsIamUserDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamUserDetails
      .builder()
      .optionallyWith(
        attachedManagedPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachedManagedPolicies)
      .optionallyWith(
        createDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createDate)
      .optionallyWith(
        groupList.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groupList)
      .optionallyWith(
        path.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(permissionsBoundary.map(value => value.buildAwsValue()))(
        _.permissionsBoundary
      )
      .optionallyWith(
        userId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(
        userName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        userPolicyList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userPolicyList)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsIamUserDetails.ReadOnly =
    zio.aws.securityhub.model.AwsIamUserDetails.wrap(buildAwsValue())
}
object AwsIamUserDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamUserDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsIamUserDetails =
      zio.aws.securityhub.model.AwsIamUserDetails(
        attachedManagedPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createDate.map(value => value),
        groupList.map(value => value),
        path.map(value => value),
        permissionsBoundary.map(value => value.asEditable),
        userId.map(value => value),
        userName.map(value => value),
        userPolicyList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def attachedManagedPolicies: Optional[
      List[zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.ReadOnly]
    ]
    def createDate: Optional[NonEmptyString]
    def groupList: Optional[List[NonEmptyString]]
    def path: Optional[NonEmptyString]
    def permissionsBoundary
        : Optional[zio.aws.securityhub.model.AwsIamPermissionsBoundary.ReadOnly]
    def userId: Optional[NonEmptyString]
    def userName: Optional[NonEmptyString]
    def userPolicyList
        : Optional[List[zio.aws.securityhub.model.AwsIamUserPolicy.ReadOnly]]
    def getAttachedManagedPolicies: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "attachedManagedPolicies",
      attachedManagedPolicies
    )
    def getCreateDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getGroupList: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("groupList", groupList)
    def getPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("path", path)
    def getPermissionsBoundary: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsIamPermissionsBoundary.ReadOnly
    ] = AwsError.unwrapOptionField("permissionsBoundary", permissionsBoundary)
    def getUserId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("userId", userId)
    def getUserName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("userName", userName)
    def getUserPolicyList: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsIamUserPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField("userPolicyList", userPolicyList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamUserDetails
  ) extends zio.aws.securityhub.model.AwsIamUserDetails.ReadOnly {
    override val attachedManagedPolicies: Optional[
      List[zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attachedManagedPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.wrap(item)
        }.toList
      )
    override val createDate: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val groupList: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val path: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val permissionsBoundary: Optional[
      zio.aws.securityhub.model.AwsIamPermissionsBoundary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.permissionsBoundary())
      .map(value =>
        zio.aws.securityhub.model.AwsIamPermissionsBoundary.wrap(value)
      )
    override val userId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val userName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val userPolicyList
        : Optional[List[zio.aws.securityhub.model.AwsIamUserPolicy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userPolicyList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.AwsIamUserPolicy.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamUserDetails
  ): zio.aws.securityhub.model.AwsIamUserDetails.ReadOnly = new Wrapper(impl)
}
