package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails(
    scanEc2InstanceWithFindings: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails
    ] = Optional.Absent,
    serviceRole: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails = {
    import AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails
      .builder()
      .optionallyWith(
        scanEc2InstanceWithFindings.map(value => value.buildAwsValue())
      )(_.scanEc2InstanceWithFindings)
      .optionallyWith(
        serviceRole.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails
      .wrap(buildAwsValue())
}
object AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails =
      zio.aws.securityhub.model
        .AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails(
          scanEc2InstanceWithFindings.map(value => value.asEditable),
          serviceRole.map(value => value)
        )
    def scanEc2InstanceWithFindings: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails.ReadOnly
    ]
    def serviceRole: Optional[NonEmptyString]
    def getScanEc2InstanceWithFindings: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scanEc2InstanceWithFindings",
      scanEc2InstanceWithFindings
    )
    def getServiceRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails
  ) extends zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails.ReadOnly {
    override val scanEc2InstanceWithFindings: Optional[
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scanEc2InstanceWithFindings())
      .map(value =>
        zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails
          .wrap(value)
      )
    override val serviceRole: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails
  ): zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails.ReadOnly =
    new Wrapper(impl)
}
